/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.api.lock.LockRequest;
import io.etcd.jetcd.api.lock.UnlockRequest;
import io.etcd.jetcd.api.lock.VertxLockGrpc;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.impl.Impl;
import io.etcd.jetcd.lock.LockResponse;
import io.etcd.jetcd.lock.UnlockResponse;
import io.etcd.jetcd.support.Errors;
import io.etcd.jetcd.support.Util;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class LockImpl
extends Impl
implements Lock {
    private final VertxLockGrpc.LockVertxStub stub;
    private final ByteSequence namespace;

    private VertxLockGrpc.LockVertxStub stubWithLeader() {
        return Util.applyRequireLeader(true, this.stub);
    }

    LockImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxLockGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<LockResponse> lock(ByteSequence name, long leaseId) {
        Objects.requireNonNull(name);
        LockRequest request = LockRequest.newBuilder().setName(Util.prefixNamespace(name, this.namespace)).setLease(leaseId).build();
        return this.execute(() -> this.stubWithLeader().lock(request), response -> new LockResponse((io.etcd.jetcd.api.lock.LockResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<UnlockResponse> unlock(ByteSequence lockKey) {
        Objects.requireNonNull(lockKey);
        UnlockRequest request = UnlockRequest.newBuilder().setKey(Util.prefixNamespace(lockKey, this.namespace)).build();
        return this.execute(() -> this.stubWithLeader().unlock(request), UnlockResponse::new, Errors::isRetryable);
    }
}

