/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.inprocess;

import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.errorprone.annotations.DoNotCall;
import io.etcd.jetcd.shaded.io.grpc.ChannelCredentials;
import io.etcd.jetcd.shaded.io.grpc.ChannelLogger;
import io.etcd.jetcd.shaded.io.grpc.ExperimentalApi;
import io.etcd.jetcd.shaded.io.grpc.Internal;
import io.etcd.jetcd.shaded.io.grpc.ManagedChannelBuilder;
import io.etcd.jetcd.shaded.io.grpc.inprocess.InProcessSocketAddress;
import io.etcd.jetcd.shaded.io.grpc.inprocess.InProcessTransport;
import io.etcd.jetcd.shaded.io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.etcd.jetcd.shaded.io.grpc.internal.ClientTransportFactory;
import io.etcd.jetcd.shaded.io.grpc.internal.ConnectionClientTransport;
import io.etcd.jetcd.shaded.io.grpc.internal.GrpcUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.ManagedChannelImplBuilder;
import io.etcd.jetcd.shaded.io.grpc.internal.SharedResourceHolder;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1783")
public final class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private final String name;
    private ScheduledExecutorService scheduledExecutorService;
    private int maxInboundMetadataSize = Integer.MAX_VALUE;
    private boolean transportIncludeStatusCause = false;

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    @DoNotCall(value="Unsupported. Use forName() instead")
    public static InProcessChannelBuilder forTarget(String target) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    @DoNotCall(value="Unsupported. Use forName() instead")
    public static InProcessChannelBuilder forAddress(String name, int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    private InProcessChannelBuilder(String name) {
        this.name = Preconditions.checkNotNull(name, "name");
        final class InProcessChannelTransportFactoryBuilder
        implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
            InProcessChannelTransportFactoryBuilder() {
            }

            @Override
            public ClientTransportFactory buildClientTransportFactory() {
                return InProcessChannelBuilder.this.buildTransportFactory();
            }
        }
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(new InProcessSocketAddress(name), "localhost", new InProcessChannelTransportFactoryBuilder(), null);
        this.managedChannelImplBuilder.setStatsRecordStartedRpcs(false);
        this.managedChannelImplBuilder.setStatsRecordFinishedRpcs(false);
    }

    @Override
    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    @Override
    public final InProcessChannelBuilder maxInboundMessageSize(int max) {
        return (InProcessChannelBuilder)super.maxInboundMessageSize(max);
    }

    @Override
    public InProcessChannelBuilder useTransportSecurity() {
        return this;
    }

    @Override
    public InProcessChannelBuilder usePlaintext() {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveWithoutCalls(boolean enable) {
        return this;
    }

    public InProcessChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService");
        return this;
    }

    @Override
    public InProcessChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    public InProcessChannelBuilder propagateCauseWithStatus(boolean enable) {
        this.transportIncludeStatusCause = enable;
        return this;
    }

    ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.name, this.scheduledExecutorService, this.maxInboundMetadataSize, this.transportIncludeStatusCause);
    }

    void setStatsEnabled(boolean value) {
        this.managedChannelImplBuilder.setStatsEnabled(value);
    }

    static final class InProcessClientTransportFactory
    implements ClientTransportFactory {
        private final String name;
        private final ScheduledExecutorService timerService;
        private final boolean useSharedTimer;
        private final int maxInboundMetadataSize;
        private boolean closed;
        private final boolean includeCauseWithStatus;

        private InProcessClientTransportFactory(String name, @Nullable ScheduledExecutorService scheduledExecutorService, int maxInboundMetadataSize, boolean includeCauseWithStatus) {
            this.name = name;
            this.useSharedTimer = scheduledExecutorService == null;
            this.timerService = this.useSharedTimer ? SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE) : scheduledExecutorService;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.includeCauseWithStatus = includeCauseWithStatus;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new InProcessTransport(this.name, this.maxInboundMetadataSize, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), this.includeCauseWithStatus);
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timerService;
        }

        @Override
        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            return null;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.useSharedTimer) {
                SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timerService);
            }
        }
    }
}

