/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.inprocess;

import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.Deadline;
import io.etcd.jetcd.shaded.io.grpc.ExperimentalApi;
import io.etcd.jetcd.shaded.io.grpc.Internal;
import io.etcd.jetcd.shaded.io.grpc.ServerBuilder;
import io.etcd.jetcd.shaded.io.grpc.ServerStreamTracer;
import io.etcd.jetcd.shaded.io.grpc.inprocess.InProcessServer;
import io.etcd.jetcd.shaded.io.grpc.internal.AbstractServerImplBuilder;
import io.etcd.jetcd.shaded.io.grpc.internal.FixedObjectPool;
import io.etcd.jetcd.shaded.io.grpc.internal.GrpcUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.InternalServer;
import io.etcd.jetcd.shaded.io.grpc.internal.ObjectPool;
import io.etcd.jetcd.shaded.io.grpc.internal.ServerImplBuilder;
import io.etcd.jetcd.shaded.io.grpc.internal.SharedResourcePool;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1783")
public final class InProcessServerBuilder
extends AbstractServerImplBuilder<InProcessServerBuilder> {
    private final ServerImplBuilder serverImplBuilder;
    final String name;
    int maxInboundMetadataSize = Integer.MAX_VALUE;
    ObjectPool<ScheduledExecutorService> schedulerPool = SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE);

    public static InProcessServerBuilder forName(String name) {
        return new InProcessServerBuilder(name);
    }

    public static InProcessServerBuilder forPort(int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    public static String generateName() {
        return UUID.randomUUID().toString();
    }

    private InProcessServerBuilder(String name) {
        this.name = Preconditions.checkNotNull(name, "name");
        final class InProcessClientTransportServersBuilder
        implements ServerImplBuilder.ClientTransportServersBuilder {
            InProcessClientTransportServersBuilder() {
            }

            @Override
            public InternalServer buildClientTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
                return InProcessServerBuilder.this.buildTransportServers(streamTracerFactories);
            }
        }
        this.serverImplBuilder = new ServerImplBuilder(new InProcessClientTransportServersBuilder());
        this.serverImplBuilder.setStatsRecordStartedRpcs(false);
        this.serverImplBuilder.setStatsRecordFinishedRpcs(false);
        this.handshakeTimeout(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    @Internal
    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    public InProcessServerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.schedulerPool = new FixedObjectPool<ScheduledExecutorService>(Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService"));
        return this;
    }

    public InProcessServerBuilder deadlineTicker(Deadline.Ticker ticker) {
        this.serverImplBuilder.setDeadlineTicker(ticker);
        return this;
    }

    @Override
    public InProcessServerBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    InProcessServer buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        return new InProcessServer(this, streamTracerFactories);
    }

    @Override
    public InProcessServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS not supported in InProcessServer");
    }

    void setStatsEnabled(boolean value) {
        this.serverImplBuilder.setStatsEnabled(value);
    }
}

