/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.grpclb;

import io.etcd.jetcd.shaded.com.google.common.base.Stopwatch;
import io.etcd.jetcd.shaded.io.grpc.Internal;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancerProvider;
import io.etcd.jetcd.shaded.io.grpc.NameResolver;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.grpclb.CachedSubchannelPool;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbConfig;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbLoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbState;
import io.etcd.jetcd.shaded.io.grpc.internal.ExponentialBackoffPolicy;
import io.etcd.jetcd.shaded.io.grpc.internal.JsonUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.ServiceConfigUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.TimeProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Internal
public final class GrpclbLoadBalancerProvider
extends LoadBalancerProvider {
    private static final GrpclbState.Mode DEFAULT_MODE = GrpclbState.Mode.ROUND_ROBIN;

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "grpclb";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new GrpclbLoadBalancer(helper, new CachedSubchannelPool(helper), TimeProvider.SYSTEM_TIME_PROVIDER, Stopwatch.createUnstarted(), new ExponentialBackoffPolicy.Provider());
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            return this.parseLoadBalancingConfigPolicyInternal(rawLoadBalancingConfigPolicy);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.fromThrowable(e).withDescription("Failed to parse GRPCLB config: " + rawLoadBalancingConfigPolicy));
        }
    }

    NameResolver.ConfigOrError parseLoadBalancingConfigPolicyInternal(Map<String, ?> rawLoadBalancingPolicyConfig) {
        if (rawLoadBalancingPolicyConfig == null) {
            return NameResolver.ConfigOrError.fromConfig(GrpclbConfig.create(DEFAULT_MODE));
        }
        String serviceName = JsonUtil.getString(rawLoadBalancingPolicyConfig, "serviceName");
        List<?> rawChildPolicies = JsonUtil.getList(rawLoadBalancingPolicyConfig, "childPolicy");
        List<ServiceConfigUtil.LbConfig> childPolicies = null;
        if (rawChildPolicies != null) {
            childPolicies = ServiceConfigUtil.unwrapLoadBalancingConfigList(JsonUtil.checkObjectList(rawChildPolicies));
        }
        if (childPolicies == null || childPolicies.isEmpty()) {
            return NameResolver.ConfigOrError.fromConfig(GrpclbConfig.create(DEFAULT_MODE, serviceName));
        }
        ArrayList<String> policiesTried = new ArrayList<String>();
        for (ServiceConfigUtil.LbConfig childPolicy : childPolicies) {
            String childPolicyName;
            switch (childPolicyName = childPolicy.getPolicyName()) {
                case "round_robin": {
                    return NameResolver.ConfigOrError.fromConfig(GrpclbConfig.create(GrpclbState.Mode.ROUND_ROBIN, serviceName));
                }
                case "pick_first": {
                    return NameResolver.ConfigOrError.fromConfig(GrpclbConfig.create(GrpclbState.Mode.PICK_FIRST, serviceName));
                }
            }
            policiesTried.add(childPolicyName);
        }
        return NameResolver.ConfigOrError.fromError(Status.INVALID_ARGUMENT.withDescription("None of " + policiesTried + " specified child policies are available."));
    }
}

