/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.common.base.Splitter;
import io.etcd.jetcd.shaded.com.google.common.collect.Iterables;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.NameResolver;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.internal.GrpcUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.SharedResourceHolder;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.GuardedBy;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPNameResolver
extends NameResolver {
    public static final String SCHEME = "ip";
    private static final Logger LOGGER = LoggerFactory.getLogger(IPNameResolver.class);
    private static final String ETCD_CLIENT_PORT = "2379";
    private final Object lock = new Object();
    private final String authority;
    private final URI targetUri;
    private final List<EquivalentAddressGroup> addresses;
    private volatile boolean shutdown;
    private volatile boolean resolving;
    @GuardedBy(value="lock")
    private Executor executor;
    @GuardedBy(value="lock")
    private NameResolver.Listener listener;

    public IPNameResolver(URI targetUri) {
        this.targetUri = targetUri;
        this.authority = targetUri.getAuthority() != null ? targetUri.getAuthority() : SCHEME;
        this.addresses = Stream.of(targetUri.getPath().split(",")).map(address -> address.startsWith("/") ? address.substring(1) : address).map(address -> {
            Iterable<String> split = Splitter.on(':').split((CharSequence)address);
            String host = Iterables.get(split, 0);
            String port = Iterables.get(split, 1, ETCD_CLIENT_PORT);
            return new InetSocketAddress(host, Integer.parseInt(port));
        }).map(address -> new EquivalentAddressGroup((SocketAddress)address, Attributes.EMPTY)).collect(Collectors.toList());
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(NameResolver.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(this.listener == null, "already started");
            this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.listener = Preconditions.checkNotNull(listener, "listener");
            this.resolve();
        }
    }

    @Override
    public final synchronized void refresh() {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor = SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.executor.execute(this::doResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolve() {
        NameResolver.Listener savedListener;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.resolving = true;
            savedListener = this.listener;
        }
        try {
            if (this.addresses.isEmpty()) {
                throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unable to resolve endpoint " + this.targetUri);
            }
            savedListener.onAddresses(this.addresses, Attributes.EMPTY);
        }
        catch (Exception e) {
            LOGGER.warn("Error wile getting list of servers", (Throwable)e);
            savedListener.onError(Status.NOT_FOUND);
        }
        finally {
            this.resolving = false;
        }
    }
}

