/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.com.google.common.graph;

import io.etcd.jetcd.shaded.com.google.common.collect.BiMap;
import io.etcd.jetcd.shaded.com.google.common.collect.HashBiMap;
import io.etcd.jetcd.shaded.com.google.common.collect.ImmutableBiMap;
import io.etcd.jetcd.shaded.com.google.common.graph.AbstractDirectedNetworkConnections;
import io.etcd.jetcd.shaded.com.google.common.graph.EdgesConnecting;
import io.etcd.jetcd.shaded.com.google.common.graph.ElementTypesAreNonnullByDefault;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
final class DirectedNetworkConnections<N, E>
extends AbstractDirectedNetworkConnections<N, E> {
    DirectedNetworkConnections(Map<E, N> inEdgeMap, Map<E, N> outEdgeMap, int selfLoopCount) {
        super(inEdgeMap, outEdgeMap, selfLoopCount);
    }

    static <N, E> DirectedNetworkConnections<N, E> of() {
        return new DirectedNetworkConnections(HashBiMap.create(2), HashBiMap.create(2), 0);
    }

    static <N, E> DirectedNetworkConnections<N, E> ofImmutable(Map<E, N> inEdges, Map<E, N> outEdges, int selfLoopCount) {
        return new DirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(inEdges), ImmutableBiMap.copyOf(outEdges), selfLoopCount);
    }

    @Override
    public Set<N> predecessors() {
        return Collections.unmodifiableSet(((BiMap)this.inEdgeMap).values());
    }

    @Override
    public Set<N> successors() {
        return Collections.unmodifiableSet(((BiMap)this.outEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.outEdgeMap).inverse(), node);
    }
}

