/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.auth;

import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.AuthGrpc;
import io.etcd.jetcd.api.AuthenticateRequest;
import io.etcd.jetcd.api.AuthenticateResponse;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.common.util.concurrent.ListenableFuture;
import io.etcd.jetcd.shaded.com.google.protobuf.ByteString;
import io.etcd.jetcd.shaded.io.grpc.CallOptions;
import io.etcd.jetcd.shaded.io.grpc.Channel;
import io.etcd.jetcd.shaded.io.grpc.ClientCall;
import io.etcd.jetcd.shaded.io.grpc.ClientInterceptor;
import io.etcd.jetcd.shaded.io.grpc.ForwardingClientCall;
import io.etcd.jetcd.shaded.io.grpc.ForwardingClientCallListener;
import io.etcd.jetcd.shaded.io.grpc.Metadata;
import io.etcd.jetcd.shaded.io.grpc.MethodDescriptor;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.stub.MetadataUtils;
import io.etcd.jetcd.shaded.javax.annotation.Nonnull;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

public class AuthInterceptor
implements ClientInterceptor {
    private static final Metadata.Key<String> TOKEN = Metadata.Key.of("token", Metadata.ASCII_STRING_MARSHALLER);
    private final Object lock = new Object();
    private final ClientBuilder builder;
    private final ClientInterceptor[] interceptors;
    private volatile String token;

    public AuthInterceptor(ClientBuilder builder) {
        this.builder = builder;
        ArrayList<ClientInterceptor> interceptorsChain = new ArrayList<ClientInterceptor>();
        if (builder.authHeaders() != null) {
            Metadata metadata = new Metadata();
            builder.authHeaders().forEach(metadata::put);
            interceptorsChain.add(MetadataUtils.newAttachHeadersInterceptor(metadata));
        }
        if (builder.authInterceptors() != null) {
            interceptorsChain.addAll(builder.authInterceptors());
        }
        this.interceptors = interceptorsChain.isEmpty() ? null : interceptorsChain.toArray(new ClientInterceptor[0]);
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, final Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                String token = AuthInterceptor.this.getToken(next);
                if (token != null) {
                    headers.put(TOKEN, token);
                }
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        if (Util.isInvalidTokenError(status)) {
                            try {
                                AuthInterceptor.this.refreshToken(next);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        super.onClose(status, trailers);
                    }
                }, headers);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.lock;
        synchronized (object) {
            this.token = null;
        }
    }

    private ListenableFuture<AuthenticateResponse> authenticate(@Nonnull Channel channel) {
        ByteString user = ByteString.copyFrom(this.builder.user().getBytes());
        ByteString pass = ByteString.copyFrom(this.builder.password().getBytes());
        Preconditions.checkArgument(!user.isEmpty(), "username can not be empty.");
        Preconditions.checkArgument(!pass.isEmpty(), "password can not be empty.");
        AuthGrpc.AuthFutureStub authFutureStub = AuthGrpc.newFutureStub(channel);
        if (this.interceptors != null) {
            authFutureStub = (AuthGrpc.AuthFutureStub)authFutureStub.withInterceptors(this.interceptors);
        }
        return authFutureStub.authenticate(AuthenticateRequest.newBuilder().setNameBytes(user).setPasswordBytes(pass).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getToken(Channel channel) {
        if (this.token == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.token == null) {
                    this.token = this.generateToken(channel);
                }
            }
        }
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshToken(Channel channel) {
        Object object = this.lock;
        synchronized (object) {
            this.token = this.generateToken(channel);
        }
    }

    @Nullable
    private String generateToken(Channel channel) {
        if (this.builder.user() != null && this.builder.password() != null) {
            try {
                return ((AuthenticateResponse)this.authenticate(channel).get()).getToken();
            }
            catch (InterruptedException ite) {
                throw EtcdExceptionFactory.handleInterrupt(ite);
            }
            catch (ExecutionException exee) {
                throw EtcdExceptionFactory.toEtcdException(exee);
            }
        }
        return null;
    }
}

