/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import io.etcd.jetcd.shaded.net.jodah.failsafe.AbstractExecution;
import io.etcd.jetcd.shaded.net.jodah.failsafe.Policy;
import io.etcd.jetcd.shaded.net.jodah.failsafe.PolicyExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.PolicyListeners;
import io.etcd.jetcd.shaded.net.jodah.failsafe.TimeoutExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.internal.util.Assert;
import java.time.Duration;

public class Timeout<R>
extends PolicyListeners<Timeout<R>, R>
implements Policy<R> {
    private final Duration timeout;
    private volatile boolean interruptable;

    private Timeout(Duration timeout) {
        this.timeout = timeout;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public boolean canCancel() {
        return true;
    }

    public boolean canInterrupt() {
        return this.interruptable;
    }

    public Timeout<R> withCancel(boolean mayInterruptIfRunning) {
        this.interruptable = mayInterruptIfRunning;
        return this;
    }

    public Timeout<R> withInterrupt(boolean mayInterruptIfRunning) {
        this.interruptable = mayInterruptIfRunning;
        return this;
    }

    public static <R> Timeout<R> of(Duration timeout) {
        Assert.notNull(timeout, "timeout");
        Assert.isTrue(timeout.toNanos() > 0L, "timeout must be > 0", new Object[0]);
        return new Timeout<R>(timeout);
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new TimeoutExecutor(this, execution);
    }
}

