/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver.dnssrv;

import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.resolver.URIResolver;
import io.etcd.jetcd.shaded.com.google.common.base.Splitter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public final class DnsSrvUriResolver
implements URIResolver {
    private static final List<String> SCHEMES = Arrays.asList("dns+srv", "dnssrv", "srv");
    private static final String[] ATTRIBUTE_IDS = new String[]{"SRV"};
    private static final Hashtable<String, String> ENV = new Hashtable();
    private final ConcurrentMap<String, SocketAddress> cache = new ConcurrentHashMap<String, SocketAddress>();

    @Override
    public int priority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean supports(URI uri) {
        return SCHEMES.contains(uri.getScheme());
    }

    @Override
    public List<SocketAddress> resolve(URI uri) {
        if (!this.supports(uri)) {
            throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unsupported URI " + uri);
        }
        LinkedList<SocketAddress> addresses = new LinkedList<SocketAddress>();
        try {
            InitialDirContext ctx = new InitialDirContext(ENV);
            Attributes attributes = ctx.getAttributes(uri.getAuthority(), ATTRIBUTE_IDS);
            NamingEnumeration<?> resolved = attributes.get("srv").getAll();
            while (resolved.hasMore()) {
                String record = (String)resolved.next();
                List<String> split = Splitter.on(' ').splitToList(record);
                if (split.size() < 4) continue;
                String host = split.get(3).trim();
                String port = split.get(2).trim();
                SocketAddress address = this.cache.computeIfAbsent(host + ":" + port, k -> new InetSocketAddress(host, Integer.parseInt(port)));
                addresses.add(address);
            }
        }
        catch (Exception e) {
            throw EtcdExceptionFactory.toEtcdException(e);
        }
        return addresses;
    }

    static {
        ENV.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ENV.put("java.naming.provider.url", "dns:");
    }
}

