/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe.internal.util;

import io.etcd.jetcd.shaded.net.jodah.failsafe.util.Ratio;
import java.util.BitSet;

public class CircularBitSet {
    final BitSet bitSet;
    private final int size;
    volatile int nextIndex;
    private volatile int occupiedBits;
    private volatile int positives;
    private volatile int negatives;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CircularBitSet(int size, CircularBitSet oldBitSet) {
        this.bitSet = new BitSet(size);
        this.size = size;
        if (oldBitSet != null) {
            CircularBitSet circularBitSet = oldBitSet;
            synchronized (circularBitSet) {
                CircularBitSet.copyBits(oldBitSet, this);
            }
        }
    }

    static void copyBits(CircularBitSet left, CircularBitSet right) {
        int bitsToCopy = Math.min(left.occupiedBits, right.size);
        int index = left.nextIndex - bitsToCopy;
        if (index < 0) {
            index += left.occupiedBits;
        }
        for (int i = 0; i < bitsToCopy; ++i) {
            right.setNext(left.bitSet.get(index));
            index = left.indexAfter(index);
        }
    }

    public int negatives() {
        return this.negatives;
    }

    public Ratio negativeRatio() {
        return new Ratio(this.negatives, this.occupiedBits);
    }

    public double negativeRatioValue() {
        return this.occupiedBits == 0 ? 0.0 : (double)this.negatives / (double)this.occupiedBits;
    }

    public int occupiedBits() {
        return this.occupiedBits;
    }

    public int positives() {
        return this.positives;
    }

    public Ratio positiveRatio() {
        return new Ratio(this.positives, this.occupiedBits);
    }

    public double positiveRatioValue() {
        return this.occupiedBits == 0 ? 0.0 : (double)this.positives / (double)this.occupiedBits;
    }

    public synchronized int setNext(boolean value) {
        int previousValue = -1;
        if (this.occupiedBits < this.size) {
            ++this.occupiedBits;
        } else {
            previousValue = this.bitSet.get(this.nextIndex) ? 1 : 0;
        }
        this.bitSet.set(this.nextIndex, value);
        this.nextIndex = this.indexAfter(this.nextIndex);
        if (value) {
            if (previousValue != 1) {
                ++this.positives;
            }
            if (previousValue == 0) {
                --this.negatives;
            }
        } else {
            if (previousValue != 0) {
                ++this.negatives;
            }
            if (previousValue == 1) {
                --this.positives;
            }
        }
        return previousValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('[');
        for (int i = 0; i < this.occupiedBits; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.bitSet.get(i));
        }
        return sb.append(']').toString();
    }

    private int indexAfter(int index) {
        return index == this.size - 1 ? 0 : index + 1;
    }
}

