/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import io.etcd.jetcd.shaded.net.jodah.failsafe.AbstractExecution;
import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionResult;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FailsafeException;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FailsafeFuture;
import io.etcd.jetcd.shaded.net.jodah.failsafe.PolicyExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.RetryPolicy;
import io.etcd.jetcd.shaded.net.jodah.failsafe.internal.EventListener;
import io.etcd.jetcd.shaded.net.jodah.failsafe.internal.util.RandomDelay;
import io.etcd.jetcd.shaded.net.jodah.failsafe.util.concurrent.Scheduler;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class RetryPolicyExecutor
extends PolicyExecutor<RetryPolicy> {
    private volatile int failedAttempts;
    private volatile boolean retriesExceeded;
    private volatile long delayNanos = -1L;
    private EventListener abortListener;
    private EventListener failedAttemptListener;
    private EventListener retriesExceededListener;
    private EventListener retryListener;

    RetryPolicyExecutor(RetryPolicy retryPolicy, AbstractExecution execution, EventListener abortListener, EventListener failedAttemptListener, EventListener retriesExceededListener, EventListener retryListener) {
        super(retryPolicy, execution);
        this.abortListener = abortListener;
        this.failedAttemptListener = failedAttemptListener;
        this.retriesExceededListener = retriesExceededListener;
        this.retryListener = retryListener;
    }

    @Override
    protected Supplier<ExecutionResult> supply(Supplier<ExecutionResult> supplier, Scheduler scheduler) {
        return () -> {
            while (true) {
                ExecutionResult result = (ExecutionResult)supplier.get();
                if (this.retriesExceeded) {
                    return result;
                }
                if ((result = this.postExecute(result)).isComplete()) {
                    return result;
                }
                try {
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(result.getWaitNanos()));
                }
                catch (InterruptedException e) {
                    if (!this.execution.interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return ExecutionResult.failure(new FailsafeException(e));
                }
                if (this.retryListener == null) continue;
                this.retryListener.handle(result, this.execution);
            }
        };
    }

    @Override
    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(final Supplier<CompletableFuture<ExecutionResult>> supplier, final Scheduler scheduler, final FailsafeFuture<Object> future) {
        return () -> {
            final CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = new Callable<Object>(){
                volatile ExecutionResult previousResult;

                @Override
                public Object call() {
                    if (RetryPolicyExecutor.this.retryListener != null && this.previousResult != null) {
                        RetryPolicyExecutor.this.retryListener.handle(this.previousResult, RetryPolicyExecutor.this.execution);
                    }
                    ((CompletableFuture)supplier.get()).whenComplete((result, error) -> {
                        if (error != null) {
                            promise.completeExceptionally((Throwable)error);
                        } else if (result != null) {
                            if (RetryPolicyExecutor.this.retriesExceeded) {
                                promise.complete(result);
                            } else {
                                RetryPolicyExecutor.this.postExecuteAsync((ExecutionResult)result, scheduler, future).whenComplete((postResult, postError) -> {
                                    if (postError != null) {
                                        promise.completeExceptionally((Throwable)postError);
                                    } else if (postResult != null) {
                                        if (RetryPolicyExecutor.this.retriesExceeded || postResult.isComplete()) {
                                            promise.complete(postResult);
                                        } else {
                                            FailsafeFuture failsafeFuture = future;
                                            synchronized (failsafeFuture) {
                                                if (!future.isDone()) {
                                                    try {
                                                        this.previousResult = postResult;
                                                        future.inject(scheduler.schedule(this, postResult.getWaitNanos(), TimeUnit.NANOSECONDS));
                                                    }
                                                    catch (Throwable t) {
                                                        promise.completeExceptionally(t);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                    return null;
                }
            };
            try {
                callable.call();
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return promise;
        };
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        boolean success;
        long maxRemainingWaitTime;
        long waitNanos;
        ++this.failedAttempts;
        Duration computedDelay = ((RetryPolicy)this.policy).computeDelay(this.execution);
        if (computedDelay == null) {
            Duration delay = ((RetryPolicy)this.policy).getDelay();
            Duration delayMin = ((RetryPolicy)this.policy).getDelayMin();
            Duration delayMax = ((RetryPolicy)this.policy).getDelayMax();
            if (this.delayNanos == -1L && delay != null && !delay.equals(Duration.ZERO)) {
                this.delayNanos = delay.toNanos();
            } else if (delayMin != null && delayMax != null) {
                this.delayNanos = RandomDelay.randomDelayInRange(delayMin.toNanos(), delayMax.toNanos(), Math.random());
            }
            if (this.execution.getAttemptCount() != 1 && ((RetryPolicy)this.policy).getMaxDelay() != null) {
                this.delayNanos = (long)Math.min((double)this.delayNanos * ((RetryPolicy)this.policy).getDelayFactor(), (double)((RetryPolicy)this.policy).getMaxDelay().toNanos());
            }
        }
        long l = waitNanos = computedDelay != null ? computedDelay.toNanos() : this.delayNanos;
        if (((RetryPolicy)this.policy).getJitter() != null) {
            waitNanos = RandomDelay.randomDelay(waitNanos, ((RetryPolicy)this.policy).getJitter().toNanos(), Math.random());
        } else if (((RetryPolicy)this.policy).getJitterFactor() > 0.0) {
            waitNanos = RandomDelay.randomDelay(waitNanos, ((RetryPolicy)this.policy).getJitterFactor(), Math.random());
        }
        long elapsedNanos = this.execution.getElapsedTime().toNanos();
        if (((RetryPolicy)this.policy).getMaxDuration() != null && (waitNanos = Math.min(waitNanos, (maxRemainingWaitTime = ((RetryPolicy)this.policy).getMaxDuration().toNanos() - elapsedNanos) < 0L ? 0L : maxRemainingWaitTime)) < 0L) {
            waitNanos = 0L;
        }
        boolean maxRetriesExceeded = ((RetryPolicy)this.policy).getMaxRetries() != -1 && this.failedAttempts > ((RetryPolicy)this.policy).getMaxRetries();
        boolean maxDurationExceeded = ((RetryPolicy)this.policy).getMaxDuration() != null && elapsedNanos > ((RetryPolicy)this.policy).getMaxDuration().toNanos();
        this.retriesExceeded = maxRetriesExceeded || maxDurationExceeded;
        boolean isAbortable = ((RetryPolicy)this.policy).isAbortable(result.getResult(), result.getFailure());
        boolean shouldRetry = !result.isSuccess() && !isAbortable && !this.retriesExceeded && ((RetryPolicy)this.policy).allowsRetries();
        boolean completed = isAbortable || !shouldRetry;
        boolean bl = success = completed && result.isSuccess() && !isAbortable;
        if (this.failedAttemptListener != null && !success) {
            this.failedAttemptListener.handle(result, this.execution);
        }
        if (this.abortListener != null && isAbortable) {
            this.abortListener.handle(result, this.execution);
        } else if (this.retriesExceededListener != null && !success && this.retriesExceeded) {
            this.retriesExceededListener.handle(result, this.execution);
        }
        return result.with(waitNanos, completed, success);
    }
}

