/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.grpclb;

import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.base.Objects;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.common.base.Stopwatch;
import io.etcd.jetcd.shaded.com.google.protobuf.util.Durations;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.ChannelLogger;
import io.etcd.jetcd.shaded.io.grpc.ConnectivityState;
import io.etcd.jetcd.shaded.io.grpc.ConnectivityStateInfo;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.ManagedChannel;
import io.etcd.jetcd.shaded.io.grpc.Metadata;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.SynchronizationContext;
import io.etcd.jetcd.shaded.io.grpc.grpclb.BackendAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbClientLoadRecorder;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbConstants;
import io.etcd.jetcd.shaded.io.grpc.grpclb.LbAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.grpclb.SubchannelPool;
import io.etcd.jetcd.shaded.io.grpc.grpclb.TokenAttachingTracerFactory;
import io.etcd.jetcd.shaded.io.grpc.internal.BackoffPolicy;
import io.etcd.jetcd.shaded.io.grpc.internal.GrpcAttributes;
import io.etcd.jetcd.shaded.io.grpc.internal.TimeProvider;
import io.etcd.jetcd.shaded.io.grpc.lb.v1.ClientStats;
import io.etcd.jetcd.shaded.io.grpc.lb.v1.InitialLoadBalanceRequest;
import io.etcd.jetcd.shaded.io.grpc.lb.v1.InitialLoadBalanceResponse;
import io.etcd.jetcd.shaded.io.grpc.lb.v1.LoadBalanceRequest;
import io.etcd.jetcd.shaded.io.grpc.lb.v1.LoadBalanceResponse;
import io.etcd.jetcd.shaded.io.grpc.lb.v1.LoadBalancerGrpc;
import io.etcd.jetcd.shaded.io.grpc.lb.v1.Server;
import io.etcd.jetcd.shaded.io.grpc.lb.v1.ServerList;
import io.etcd.jetcd.shaded.io.grpc.stub.StreamObserver;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.NotThreadSafe;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@NotThreadSafe
final class GrpclbState {
    static final long FALLBACK_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final Attributes LB_PROVIDED_BACKEND_ATTRS = Attributes.newBuilder().set(GrpcAttributes.ATTR_LB_PROVIDED_BACKEND, true).build();
    @VisibleForTesting
    static final LoadBalancer.PickResult DROP_PICK_RESULT = LoadBalancer.PickResult.withDrop(Status.UNAVAILABLE.withDescription("Dropped as requested by balancer"));
    @VisibleForTesting
    static final RoundRobinEntry BUFFER_ENTRY = new RoundRobinEntry(){

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return "BUFFER_ENTRY";
        }
    };
    private final String serviceName;
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final SubchannelPool subchannelPool;
    private final TimeProvider time;
    private final Stopwatch stopwatch;
    private final ScheduledExecutorService timerService;
    private static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create("io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbLoadBalancer.stateInfo");
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final ChannelLogger logger;
    @Nullable
    private SynchronizationContext.ScheduledHandle fallbackTimer;
    private List<EquivalentAddressGroup> fallbackBackendList = Collections.emptyList();
    private boolean usingFallbackBackends;
    private boolean balancerWorking;
    @Nullable
    private BackoffPolicy lbRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lbRpcRetryTimer;
    @Nullable
    private ManagedChannel lbCommChannel;
    @Nullable
    private LbStream lbStream;
    private Map<List<EquivalentAddressGroup>, LoadBalancer.Subchannel> subchannels = Collections.emptyMap();
    private final Mode mode;
    private List<DropEntry> dropList = Collections.emptyList();
    private List<BackendEntry> backendList = Collections.emptyList();
    private RoundRobinPicker currentPicker = new RoundRobinPicker(Collections.emptyList(), Arrays.asList(BUFFER_ENTRY));

    GrpclbState(Mode mode, LoadBalancer.Helper helper, SubchannelPool subchannelPool, TimeProvider time, Stopwatch stopwatch, BackoffPolicy.Provider backoffPolicyProvider) {
        this.mode = Preconditions.checkNotNull(mode, "mode");
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.subchannelPool = mode == Mode.ROUND_ROBIN ? Preconditions.checkNotNull(subchannelPool, "subchannelPool") : null;
        this.time = Preconditions.checkNotNull(time, "time provider");
        this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
        this.timerService = Preconditions.checkNotNull(helper.getScheduledExecutorService(), "timerService");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.serviceName = Preconditions.checkNotNull(helper.getAuthority(), "helper returns null authority");
        this.logger = Preconditions.checkNotNull(helper.getChannelLogger(), "logger");
    }

    void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        if (newState.getState() == ConnectivityState.SHUTDOWN) {
            return;
        }
        if (!this.subchannels.values().contains(subchannel)) {
            if (this.subchannelPool != null) {
                this.subchannelPool.handleSubchannelState(subchannel, newState);
            }
            return;
        }
        if (this.mode == Mode.ROUND_ROBIN && newState.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        subchannel.getAttributes().get(STATE_INFO).set(newState);
        this.maybeUseFallbackBackends();
        this.maybeUpdatePicker();
    }

    void handleAddresses(List<LbAddressGroup> newLbAddressGroups, List<EquivalentAddressGroup> newBackendServers) {
        if (newLbAddressGroups.isEmpty()) {
            this.shutdownLbComm();
            this.syncContext.execute(new FallbackModeTask());
        } else {
            LbAddressGroup newLbAddressGroup = this.flattenLbAddressGroups(newLbAddressGroups);
            this.startLbComm(newLbAddressGroup);
            if (this.lbStream == null) {
                this.startLbRpc();
            }
            if (this.fallbackTimer == null) {
                this.fallbackTimer = this.syncContext.schedule(new FallbackModeTask(), FALLBACK_TIMEOUT_MS, TimeUnit.MILLISECONDS, this.timerService);
            }
        }
        this.fallbackBackendList = newBackendServers;
        if (this.usingFallbackBackends) {
            this.useFallbackBackends();
        }
        this.maybeUpdatePicker();
    }

    void requestConnection() {
        for (RoundRobinEntry roundRobinEntry : this.currentPicker.pickList) {
            if (!(roundRobinEntry instanceof IdleSubchannelEntry)) continue;
            ((IdleSubchannelEntry)roundRobinEntry).subchannel.requestConnection();
        }
    }

    private void maybeUseFallbackBackends() {
        if (this.balancerWorking) {
            return;
        }
        if (this.usingFallbackBackends) {
            return;
        }
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            if (subchannel.getAttributes().get(STATE_INFO).get().getState() != ConnectivityState.READY) continue;
            return;
        }
        this.useFallbackBackends();
    }

    private void useFallbackBackends() {
        this.usingFallbackBackends = true;
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "Using fallback backends");
        ArrayList<DropEntry> newDropList = new ArrayList<DropEntry>();
        ArrayList<BackendAddressGroup> newBackendAddrList = new ArrayList<BackendAddressGroup>();
        for (EquivalentAddressGroup eag : this.fallbackBackendList) {
            newDropList.add(null);
            newBackendAddrList.add(new BackendAddressGroup(eag, null));
        }
        this.useRoundRobinLists(newDropList, newBackendAddrList, null);
    }

    private void shutdownLbComm() {
        if (this.lbCommChannel != null) {
            this.lbCommChannel.shutdown();
            this.lbCommChannel = null;
        }
        this.shutdownLbRpc();
    }

    private void shutdownLbRpc() {
        if (this.lbStream != null) {
            this.lbStream.close(Status.CANCELLED.withDescription("balancer shutdown").asException());
        }
    }

    private void startLbComm(LbAddressGroup lbAddressGroup) {
        Preconditions.checkNotNull(lbAddressGroup, "lbAddressGroup");
        if (this.lbCommChannel == null) {
            this.lbCommChannel = this.helper.createOobChannel(lbAddressGroup.getAddresses(), lbAddressGroup.getAuthority());
        } else if (lbAddressGroup.getAuthority().equals(this.lbCommChannel.authority())) {
            this.helper.updateOobChannelAddresses(this.lbCommChannel, lbAddressGroup.getAddresses());
        } else {
            this.shutdownLbComm();
            this.lbCommChannel = this.helper.createOobChannel(lbAddressGroup.getAddresses(), lbAddressGroup.getAuthority());
        }
    }

    private void startLbRpc() {
        Preconditions.checkState(this.lbStream == null, "previous lbStream has not been cleared yet");
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub(this.lbCommChannel);
        this.lbStream = new LbStream(stub);
        this.lbStream.start();
        this.stopwatch.reset().start();
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        try {
            this.lbStream.lbRequestWriter.onNext(initRequest);
        }
        catch (Exception e) {
            this.lbStream.close(e);
        }
    }

    private void cancelFallbackTimer() {
        if (this.fallbackTimer != null) {
            this.fallbackTimer.cancel();
        }
    }

    private void cancelLbRpcRetryTimer() {
        if (this.lbRpcRetryTimer != null) {
            this.lbRpcRetryTimer.cancel();
        }
    }

    void shutdown() {
        this.shutdownLbComm();
        switch (this.mode) {
            case ROUND_ROBIN: {
                for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
                    this.returnSubchannelToPool(subchannel);
                }
                this.subchannelPool.clear();
                break;
            }
            case PICK_FIRST: {
                if (this.subchannels.isEmpty()) break;
                Preconditions.checkState(this.subchannels.size() == 1, "Excessive Subchannels: %s", this.subchannels);
                this.subchannels.values().iterator().next().shutdown();
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing case for " + (Object)((Object)this.mode)));
            }
        }
        this.subchannels = Collections.emptyMap();
        this.cancelFallbackTimer();
        this.cancelLbRpcRetryTimer();
    }

    void propagateError(Status status) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Error: {0}", status);
        if (this.backendList.isEmpty()) {
            this.maybeUpdatePicker(ConnectivityState.TRANSIENT_FAILURE, new RoundRobinPicker(this.dropList, Arrays.asList(new ErrorEntry(status))));
        }
    }

    private void returnSubchannelToPool(LoadBalancer.Subchannel subchannel) {
        this.subchannelPool.returnSubchannel(subchannel, subchannel.getAttributes().get(STATE_INFO).get());
    }

    @Nullable
    @VisibleForTesting
    GrpclbClientLoadRecorder getLoadRecorder() {
        if (this.lbStream == null) {
            return null;
        }
        return this.lbStream.loadRecorder;
    }

    /*
     * WARNING - void declaration
     */
    private void useRoundRobinLists(List<DropEntry> newDropList, List<BackendAddressGroup> newBackendAddrList, @Nullable GrpclbClientLoadRecorder loadRecorder) {
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "Using RR list={0}, drop={1}", newBackendAddrList, newDropList);
        HashMap<List<EquivalentAddressGroup>, LoadBalancer.Subchannel> newSubchannelMap = new HashMap<List<EquivalentAddressGroup>, LoadBalancer.Subchannel>();
        ArrayList<BackendEntry> newBackendList = new ArrayList<BackendEntry>();
        switch (this.mode) {
            case ROUND_ROBIN: {
                for (BackendAddressGroup backendAddressGroup : newBackendAddrList) {
                    EquivalentAddressGroup eag = backendAddressGroup.getAddresses();
                    List<EquivalentAddressGroup> eagAsList = Collections.singletonList(eag);
                    LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)newSubchannelMap.get(eagAsList);
                    if (subchannel == null) {
                        subchannel = this.subchannels.get(eagAsList);
                        if (subchannel == null) {
                            subchannel = this.subchannelPool.takeOrCreateSubchannel(eag, GrpclbState.createSubchannelAttrs());
                            subchannel.requestConnection();
                        }
                        newSubchannelMap.put(eagAsList, subchannel);
                    }
                    BackendEntry entry = backendAddressGroup.getToken() == null ? new BackendEntry(subchannel) : new BackendEntry(subchannel, loadRecorder, backendAddressGroup.getToken());
                    newBackendList.add(entry);
                }
                for (Map.Entry entry : this.subchannels.entrySet()) {
                    List eagList = (List)entry.getKey();
                    if (newSubchannelMap.containsKey(eagList)) continue;
                    this.returnSubchannelToPool((LoadBalancer.Subchannel)entry.getValue());
                }
                this.subchannels = Collections.unmodifiableMap(newSubchannelMap);
                break;
            }
            case PICK_FIRST: {
                void var7_14;
                ArrayList<EquivalentAddressGroup> eagList = new ArrayList<EquivalentAddressGroup>();
                for (BackendAddressGroup bag : newBackendAddrList) {
                    EquivalentAddressGroup origEag = bag.getAddresses();
                    Attributes eagAttrs = origEag.getAttributes();
                    if (bag.getToken() != null) {
                        eagAttrs = eagAttrs.toBuilder().set(GrpclbConstants.TOKEN_ATTRIBUTE_KEY, bag.getToken()).build();
                    }
                    eagList.add(new EquivalentAddressGroup(origEag.getAddresses(), eagAttrs));
                }
                if (this.subchannels.isEmpty()) {
                    LoadBalancer.Subchannel subchannel = this.helper.createSubchannel(eagList, GrpclbState.createSubchannelAttrs());
                } else {
                    Preconditions.checkState(this.subchannels.size() == 1, "Unexpected Subchannel count: %s", this.subchannels);
                    LoadBalancer.Subchannel subchannel = this.subchannels.values().iterator().next();
                    subchannel.updateAddresses(eagList);
                }
                this.subchannels = Collections.singletonMap(eagList, var7_14);
                newBackendList.add(new BackendEntry((LoadBalancer.Subchannel)var7_14, new TokenAttachingTracerFactory(loadRecorder)));
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing case for " + (Object)((Object)this.mode)));
            }
        }
        this.dropList = Collections.unmodifiableList(newDropList);
        this.backendList = Collections.unmodifiableList(newBackendList);
    }

    private void maybeUpdatePicker() {
        ConnectivityState state;
        List<Object> pickList;
        block0 : switch (this.mode) {
            case ROUND_ROBIN: {
                pickList = new ArrayList(this.backendList.size());
                Status error = null;
                boolean hasIdle = false;
                for (BackendEntry entry : this.backendList) {
                    LoadBalancer.Subchannel subchannel = entry.subchannel;
                    Attributes attrs = subchannel.getAttributes();
                    ConnectivityStateInfo stateInfo = attrs.get(STATE_INFO).get();
                    if (stateInfo.getState() == ConnectivityState.READY) {
                        pickList.add(entry);
                        continue;
                    }
                    if (stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE) {
                        error = stateInfo.getStatus();
                        continue;
                    }
                    if (stateInfo.getState() != ConnectivityState.IDLE) continue;
                    hasIdle = true;
                }
                if (pickList.isEmpty()) {
                    if (error != null && !hasIdle) {
                        pickList.add(new ErrorEntry(error));
                        state = ConnectivityState.TRANSIENT_FAILURE;
                        break;
                    }
                    pickList.add(BUFFER_ENTRY);
                    state = ConnectivityState.CONNECTING;
                    break;
                }
                state = ConnectivityState.READY;
                break;
            }
            case PICK_FIRST: {
                if (this.backendList.isEmpty()) {
                    pickList = Collections.singletonList(BUFFER_ENTRY);
                    state = ConnectivityState.CONNECTING;
                    break;
                }
                Preconditions.checkState(this.backendList.size() == 1, "Excessive backend entries: %s", this.backendList);
                BackendEntry onlyEntry = this.backendList.get(0);
                ConnectivityStateInfo stateInfo = onlyEntry.subchannel.getAttributes().get(STATE_INFO).get();
                state = stateInfo.getState();
                switch (state) {
                    case READY: {
                        pickList = Collections.singletonList(onlyEntry);
                        break block0;
                    }
                    case TRANSIENT_FAILURE: {
                        pickList = Collections.singletonList(new ErrorEntry(stateInfo.getStatus()));
                        break block0;
                    }
                    case CONNECTING: {
                        pickList = Collections.singletonList(BUFFER_ENTRY);
                        break block0;
                    }
                }
                pickList = Collections.singletonList(new IdleSubchannelEntry(onlyEntry.subchannel, this.syncContext));
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing case for " + (Object)((Object)this.mode)));
            }
        }
        this.maybeUpdatePicker(state, new RoundRobinPicker(this.dropList, pickList));
    }

    private void maybeUpdatePicker(ConnectivityState state, RoundRobinPicker picker) {
        if (picker.dropList.equals(this.currentPicker.dropList) && picker.pickList.equals(this.currentPicker.pickList)) {
            return;
        }
        this.currentPicker = picker;
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "{0}: picks={1}, drops={2}", new Object[]{state, picker.pickList, picker.dropList});
        this.helper.updateBalancingState(state, picker);
    }

    private LbAddressGroup flattenLbAddressGroups(List<LbAddressGroup> groupList) {
        assert (!groupList.isEmpty());
        ArrayList<EquivalentAddressGroup> eags = new ArrayList<EquivalentAddressGroup>(groupList.size());
        String authority = groupList.get(0).getAuthority();
        for (LbAddressGroup group : groupList) {
            if (!authority.equals(group.getAuthority())) {
                this.logger.log(ChannelLogger.ChannelLogLevel.WARNING, "Multiple authorities found for LB. Skipping addresses for {0} in preference to {1}", group.getAuthority(), authority);
                continue;
            }
            eags.add(group.getAddresses());
        }
        Attributes attrs = Attributes.newBuilder().set(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY, authority).build();
        return new LbAddressGroup(GrpclbState.flattenEquivalentAddressGroup(eags, attrs), authority);
    }

    private static EquivalentAddressGroup flattenEquivalentAddressGroup(List<EquivalentAddressGroup> groupList, Attributes attrs) {
        ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>();
        for (EquivalentAddressGroup group : groupList) {
            addrs.addAll(group.getAddresses());
        }
        return new EquivalentAddressGroup(addrs, attrs);
    }

    private static Attributes createSubchannelAttrs() {
        return Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError(ConnectivityState.IDLE))).build();
    }

    @VisibleForTesting
    static final class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        @VisibleForTesting
        final List<DropEntry> dropList;
        private int dropIndex;
        @VisibleForTesting
        final List<? extends RoundRobinEntry> pickList;
        private int pickIndex;

        RoundRobinPicker(List<DropEntry> dropList, List<? extends RoundRobinEntry> pickList) {
            this.dropList = Preconditions.checkNotNull(dropList, "dropList");
            this.pickList = Preconditions.checkNotNull(pickList, "pickList");
            Preconditions.checkArgument(!pickList.isEmpty(), "pickList is empty");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            List<? extends RoundRobinEntry> list = this.pickList;
            synchronized (list) {
                if (!this.dropList.isEmpty()) {
                    DropEntry drop = this.dropList.get(this.dropIndex);
                    ++this.dropIndex;
                    if (this.dropIndex == this.dropList.size()) {
                        this.dropIndex = 0;
                    }
                    if (drop != null) {
                        return drop.picked();
                    }
                }
                RoundRobinEntry pick = this.pickList.get(this.pickIndex);
                ++this.pickIndex;
                if (this.pickIndex == this.pickList.size()) {
                    this.pickIndex = 0;
                }
                return pick.picked(args.getHeaders());
            }
        }
    }

    @VisibleForTesting
    static final class ErrorEntry
    implements RoundRobinEntry {
        final LoadBalancer.PickResult result;

        ErrorEntry(Status status) {
            this.result = LoadBalancer.PickResult.withError(status);
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            return this.result;
        }

        public int hashCode() {
            return Objects.hashCode(this.result);
        }

        public boolean equals(Object other) {
            if (!(other instanceof ErrorEntry)) {
                return false;
            }
            return Objects.equal(this.result, ((ErrorEntry)other).result);
        }

        public String toString() {
            return this.result.getStatus().toString();
        }
    }

    @VisibleForTesting
    static final class IdleSubchannelEntry
    implements RoundRobinEntry {
        private final SynchronizationContext syncContext;
        private final LoadBalancer.Subchannel subchannel;
        private final AtomicBoolean connectionRequested = new AtomicBoolean(false);

        IdleSubchannelEntry(LoadBalancer.Subchannel subchannel, SynchronizationContext syncContext) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
            this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext");
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            if (this.connectionRequested.compareAndSet(false, true)) {
                this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        IdleSubchannelEntry.this.subchannel.requestConnection();
                    }
                });
            }
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return "(idle)[" + this.subchannel.getAllAddresses().toString() + "]";
        }

        public int hashCode() {
            return Objects.hashCode(this.subchannel, this.syncContext);
        }

        public boolean equals(Object other) {
            if (!(other instanceof IdleSubchannelEntry)) {
                return false;
            }
            IdleSubchannelEntry that = (IdleSubchannelEntry)other;
            return Objects.equal(this.subchannel, that.subchannel) && Objects.equal(this.syncContext, that.syncContext);
        }
    }

    @VisibleForTesting
    static final class BackendEntry
    implements RoundRobinEntry {
        final LoadBalancer.Subchannel subchannel;
        @VisibleForTesting
        final LoadBalancer.PickResult result;
        @Nullable
        private final String token;

        BackendEntry(LoadBalancer.Subchannel subchannel, GrpclbClientLoadRecorder loadRecorder, String token) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
            this.result = LoadBalancer.PickResult.withSubchannel(subchannel, Preconditions.checkNotNull(loadRecorder, "loadRecorder"));
            this.token = Preconditions.checkNotNull(token, "token");
        }

        BackendEntry(LoadBalancer.Subchannel subchannel) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
            this.result = LoadBalancer.PickResult.withSubchannel(subchannel);
            this.token = null;
        }

        BackendEntry(LoadBalancer.Subchannel subchannel, TokenAttachingTracerFactory tracerFactory) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
            this.result = LoadBalancer.PickResult.withSubchannel(subchannel, Preconditions.checkNotNull(tracerFactory, "tracerFactory"));
            this.token = null;
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            headers.discardAll(GrpclbConstants.TOKEN_METADATA_KEY);
            if (this.token != null) {
                headers.put(GrpclbConstants.TOKEN_METADATA_KEY, this.token);
            }
            return this.result;
        }

        public String toString() {
            return "[" + this.subchannel.getAllAddresses().toString() + "(" + this.token + ")]";
        }

        public int hashCode() {
            return Objects.hashCode(this.result, this.token);
        }

        public boolean equals(Object other) {
            if (!(other instanceof BackendEntry)) {
                return false;
            }
            BackendEntry that = (BackendEntry)other;
            return Objects.equal(this.result, that.result) && Objects.equal(this.token, that.token);
        }
    }

    @VisibleForTesting
    static interface RoundRobinEntry {
        public LoadBalancer.PickResult picked(Metadata var1);
    }

    @VisibleForTesting
    static final class DropEntry {
        private final GrpclbClientLoadRecorder loadRecorder;
        private final String token;

        DropEntry(GrpclbClientLoadRecorder loadRecorder, String token) {
            this.loadRecorder = Preconditions.checkNotNull(loadRecorder, "loadRecorder");
            this.token = Preconditions.checkNotNull(token, "token");
        }

        LoadBalancer.PickResult picked() {
            this.loadRecorder.recordDroppedRequest(this.token);
            return DROP_PICK_RESULT;
        }

        public String toString() {
            return "drop(" + this.token + ")";
        }

        public int hashCode() {
            return Objects.hashCode(this.loadRecorder, this.token);
        }

        public boolean equals(Object other) {
            if (!(other instanceof DropEntry)) {
                return false;
            }
            DropEntry that = (DropEntry)other;
            return Objects.equal(this.loadRecorder, that.loadRecorder) && Objects.equal(this.token, that.token);
        }
    }

    private class LbStream
    implements StreamObserver<LoadBalanceResponse> {
        final GrpclbClientLoadRecorder loadRecorder;
        final LoadBalancerGrpc.LoadBalancerStub stub;
        StreamObserver<LoadBalanceRequest> lbRequestWriter;
        boolean initialResponseReceived;
        boolean closed;
        long loadReportIntervalMillis = -1L;
        SynchronizationContext.ScheduledHandle loadReportTimer;

        LbStream(LoadBalancerGrpc.LoadBalancerStub stub) {
            this.stub = Preconditions.checkNotNull(stub, "stub");
            this.loadRecorder = new GrpclbClientLoadRecorder(GrpclbState.this.time);
        }

        void start() {
            this.lbRequestWriter = ((LoadBalancerGrpc.LoadBalancerStub)this.stub.withWaitForReady()).balanceLoad(this);
        }

        @Override
        public void onNext(final LoadBalanceResponse response) {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleResponse(response);
                }
            });
        }

        @Override
        public void onError(final Throwable error) {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.fromThrowable(error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
                }
            });
        }

        @Override
        public void onCompleted() {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Stream to GRPCLB LoadBalancer was closed"));
                }
            });
        }

        private void sendLoadReport() {
            if (this.closed) {
                return;
            }
            ClientStats stats = this.loadRecorder.generateLoadReport();
            try {
                this.lbRequestWriter.onNext(LoadBalanceRequest.newBuilder().setClientStats(stats).build());
                this.scheduleNextLoadReport();
            }
            catch (Exception e) {
                this.close(e);
            }
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportIntervalMillis > 0L) {
                this.loadReportTimer = GrpclbState.this.syncContext.schedule(new LoadReportingTask(this), this.loadReportIntervalMillis, TimeUnit.MILLISECONDS, GrpclbState.this.timerService);
            }
        }

        private void handleResponse(LoadBalanceResponse response) {
            if (this.closed) {
                return;
            }
            GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Got an LB response: {0}", response);
            LoadBalanceResponse.LoadBalanceResponseTypeCase typeCase = response.getLoadBalanceResponseTypeCase();
            if (!this.initialResponseReceived) {
                if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.INITIAL_RESPONSE) {
                    GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.WARNING, "Received a response without initial response");
                    return;
                }
                this.initialResponseReceived = true;
                InitialLoadBalanceResponse initialResponse = response.getInitialResponse();
                this.loadReportIntervalMillis = Durations.toMillis(initialResponse.getClientStatsReportInterval());
                this.scheduleNextLoadReport();
                return;
            }
            if (typeCase == LoadBalanceResponse.LoadBalanceResponseTypeCase.FALLBACK_RESPONSE) {
                GrpclbState.this.cancelFallbackTimer();
                GrpclbState.this.useFallbackBackends();
                GrpclbState.this.maybeUpdatePicker();
                return;
            }
            if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.SERVER_LIST) {
                GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.WARNING, "Ignoring unexpected response type: {0}", typeCase);
                return;
            }
            GrpclbState.this.balancerWorking = true;
            ServerList serverList = response.getServerList();
            ArrayList<DropEntry> newDropList = new ArrayList<DropEntry>();
            ArrayList<BackendAddressGroup> newBackendAddrList = new ArrayList<BackendAddressGroup>();
            for (Server server : serverList.getServersList()) {
                InetSocketAddress address;
                String token = server.getLoadBalanceToken();
                if (server.getDrop()) {
                    newDropList.add(new DropEntry(this.loadRecorder, token));
                    continue;
                }
                newDropList.add(null);
                try {
                    address = new InetSocketAddress(InetAddress.getByAddress(server.getIpAddress().toByteArray()), server.getPort());
                }
                catch (UnknownHostException e) {
                    GrpclbState.this.propagateError(Status.UNAVAILABLE.withDescription("Host for server not found: " + server).withCause(e));
                    continue;
                }
                EquivalentAddressGroup eag = new EquivalentAddressGroup(address, LB_PROVIDED_BACKEND_ATTRS);
                newBackendAddrList.add(new BackendAddressGroup(eag, token));
            }
            GrpclbState.this.usingFallbackBackends = false;
            GrpclbState.this.cancelFallbackTimer();
            GrpclbState.this.useRoundRobinLists(newDropList, newBackendAddrList, this.loadRecorder);
            GrpclbState.this.maybeUpdatePicker();
        }

        private void handleStreamClosed(Status error) {
            Preconditions.checkArgument(!error.isOk(), "unexpected OK status");
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            GrpclbState.this.propagateError(error);
            GrpclbState.this.balancerWorking = false;
            GrpclbState.this.maybeUseFallbackBackends();
            GrpclbState.this.maybeUpdatePicker();
            long delayNanos = 0L;
            if (this.initialResponseReceived || GrpclbState.this.lbRpcRetryPolicy == null) {
                GrpclbState.this.lbRpcRetryPolicy = GrpclbState.this.backoffPolicyProvider.get();
            }
            if (!this.initialResponseReceived) {
                delayNanos = GrpclbState.this.lbRpcRetryPolicy.nextBackoffNanos() - GrpclbState.this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            }
            if (delayNanos <= 0L) {
                GrpclbState.this.startLbRpc();
            } else {
                GrpclbState.this.lbRpcRetryTimer = GrpclbState.this.syncContext.schedule(new LbRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, GrpclbState.this.timerService);
            }
            GrpclbState.this.helper.refreshNameResolution();
        }

        void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.lbRequestWriter.onError(error);
        }

        private void cleanUp() {
            if (this.loadReportTimer != null) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (GrpclbState.this.lbStream == this) {
                GrpclbState.this.lbStream = null;
            }
        }
    }

    @VisibleForTesting
    static class LoadReportingTask
    implements Runnable {
        private final LbStream stream;

        LoadReportingTask(LbStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.loadReportTimer = null;
            this.stream.sendLoadReport();
        }
    }

    @VisibleForTesting
    class LbRpcRetryTask
    implements Runnable {
        LbRpcRetryTask() {
        }

        @Override
        public void run() {
            GrpclbState.this.startLbRpc();
        }
    }

    @VisibleForTesting
    class FallbackModeTask
    implements Runnable {
        FallbackModeTask() {
        }

        @Override
        public void run() {
            GrpclbState.this.maybeUseFallbackBackends();
            GrpclbState.this.maybeUpdatePicker();
        }
    }

    static enum Mode {
        ROUND_ROBIN,
        PICK_FIRST;

    }
}

