/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.shaded.com.google.protobuf.ByteString;
import java.nio.charset.Charset;

public final class ByteSequence {
    public static final ByteSequence EMPTY = new ByteSequence(ByteString.EMPTY);
    public static final ByteSequence NAMESPACE_DELIMITER = ByteSequence.from(new byte[]{47});
    private final int hashVal;
    private final ByteString byteString;

    private ByteSequence(ByteString byteString) {
        this.byteString = byteString;
        this.hashVal = byteString.hashCode();
    }

    public boolean startsWith(ByteSequence prefix) {
        ByteString baseByteString = this.getByteString();
        ByteString prefixByteString = prefix.getByteString();
        return baseByteString.startsWith(prefixByteString);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)obj;
            if (other.hashCode() != this.hashCode()) {
                return false;
            }
            return this.byteString.equals(other.byteString);
        }
        return false;
    }

    public int hashCode() {
        return this.hashVal;
    }

    ByteString getByteString() {
        return this.byteString;
    }

    public String toString(Charset charset) {
        return this.byteString.toString(charset);
    }

    public byte[] getBytes() {
        return this.byteString.toByteArray();
    }

    public boolean isEmpty() {
        return this.byteString.isEmpty();
    }

    public int size() {
        return this.byteString.size();
    }

    public static ByteSequence from(String source, Charset charset) {
        byte[] bytes = source.getBytes(charset);
        return new ByteSequence(ByteString.copyFrom(bytes));
    }

    public static ByteSequence from(ByteString source) {
        return new ByteSequence(source);
    }

    public static ByteSequence from(byte[] source) {
        return new ByteSequence(ByteString.copyFrom(source));
    }
}

