/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import io.etcd.jetcd.shaded.net.jodah.failsafe.AbstractExecution;
import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionContext;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FailurePolicy;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FallbackExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.Functions;
import io.etcd.jetcd.shaded.net.jodah.failsafe.PolicyExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.event.ExecutionAttemptedEvent;
import io.etcd.jetcd.shaded.net.jodah.failsafe.function.CheckedConsumer;
import io.etcd.jetcd.shaded.net.jodah.failsafe.function.CheckedFunction;
import io.etcd.jetcd.shaded.net.jodah.failsafe.function.CheckedRunnable;
import io.etcd.jetcd.shaded.net.jodah.failsafe.function.CheckedSupplier;
import io.etcd.jetcd.shaded.net.jodah.failsafe.internal.util.Assert;

public class Fallback<R>
extends FailurePolicy<Fallback<R>, R> {
    private final CheckedFunction<ExecutionAttemptedEvent, R> fallback;
    private boolean async;

    private Fallback(CheckedFunction<ExecutionAttemptedEvent, R> fallback, boolean async) {
        this.fallback = Assert.notNull(fallback, "fallback");
        this.async = async;
    }

    public static <R> Fallback<R> of(CheckedRunnable fallback) {
        return new Fallback<CheckedRunnable>(Functions.toFn(Assert.notNull(fallback, "fallback")), false);
    }

    public static <R> Fallback<R> of(CheckedSupplier<? extends R> fallback) {
        return new Fallback<CheckedSupplier<? extends R>>(Functions.toFn(Assert.notNull(fallback, "fallback")), false);
    }

    public static <R> Fallback<R> of(CheckedConsumer<ExecutionAttemptedEvent<? extends R>> fallback) {
        return new Fallback<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(Functions.toFn(Assert.notNull(fallback, "fallback")), false);
    }

    public static <R> Fallback<R> of(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends R> fallback) {
        return new Fallback<R>(Assert.notNull(fallback, "fallback"), false);
    }

    public static <R> Fallback<R> ofException(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends Exception> fallback) {
        Assert.notNull(fallback, "fallback");
        return new Fallback<Object>(e -> {
            throw (Exception)fallback.apply((ExecutionAttemptedEvent)e);
        }, false);
    }

    public static <R> Fallback<R> of(R fallback) {
        return new Fallback<R>(Functions.toFn(fallback), false);
    }

    public static <R> Fallback<R> ofAsync(CheckedRunnable fallback) {
        return new Fallback<CheckedRunnable>(Functions.toFn(Assert.notNull(fallback, "fallback")), true);
    }

    public static <R> Fallback<R> ofAsync(CheckedSupplier<? extends R> fallback) {
        return new Fallback<CheckedSupplier<? extends R>>(Functions.toFn(Assert.notNull(fallback, "fallback")), true);
    }

    public static <R> Fallback<R> ofAsync(CheckedConsumer<ExecutionAttemptedEvent<? extends R>> fallback) {
        return new Fallback<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(Functions.toFn(Assert.notNull(fallback, "fallback")), true);
    }

    public static <R> Fallback<R> ofAsync(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends R> fallback) {
        return new Fallback<R>(Assert.notNull(fallback, "fallback"), true);
    }

    public R apply(R result, Throwable failure, ExecutionContext context) throws Exception {
        return this.fallback.apply(new ExecutionAttemptedEvent<R>(result, failure, context));
    }

    public boolean isAsync() {
        return this.async;
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new FallbackExecutor(this, execution);
    }
}

