/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.grpclb;

import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.common.base.Stopwatch;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.ChannelLogger;
import io.etcd.jetcd.shaded.io.grpc.ConnectivityStateInfo;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbState;
import io.etcd.jetcd.shaded.io.grpc.grpclb.LbAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.grpclb.SubchannelPool;
import io.etcd.jetcd.shaded.io.grpc.internal.BackoffPolicy;
import io.etcd.jetcd.shaded.io.grpc.internal.GrpcAttributes;
import io.etcd.jetcd.shaded.io.grpc.internal.ServiceConfigUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.TimeProvider;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class GrpclbLoadBalancer
extends LoadBalancer {
    private static final GrpclbState.Mode DEFAULT_MODE = GrpclbState.Mode.ROUND_ROBIN;
    private static final Logger logger = Logger.getLogger(GrpclbLoadBalancer.class.getName());
    private static final AtomicInteger pickFirstGlobalIndex = new AtomicInteger();
    private final int pickFirstIndex = pickFirstGlobalIndex.getAndIncrement() & 0xFFFFFF;
    private final LoadBalancer.Helper helper;
    private final TimeProvider time;
    private final Stopwatch stopwatch;
    private final SubchannelPool subchannelPool;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private GrpclbState.Mode mode = GrpclbState.Mode.ROUND_ROBIN;
    @Nullable
    private GrpclbState grpclbState;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, SubchannelPool subchannelPool, TimeProvider time, Stopwatch stopwatch, BackoffPolicy.Provider backoffPolicyProvider) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.time = Preconditions.checkNotNull(time, "time provider");
        this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.subchannelPool = Preconditions.checkNotNull(subchannelPool, "subchannelPool");
        this.subchannelPool.init(helper, this);
        this.recreateStates();
        Preconditions.checkNotNull(this.grpclbState, "grpclbState");
    }

    @Override
    @Deprecated
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        this.grpclbState.handleSubchannelState(subchannel, newState);
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        List<EquivalentAddressGroup> updatedServers = resolvedAddresses.getAddresses();
        Attributes attributes = resolvedAddresses.getAttributes();
        List<LbAddressGroup> newLbAddressGroups = new ArrayList();
        List<EquivalentAddressGroup> newBackendServers = new ArrayList();
        for (EquivalentAddressGroup server : updatedServers) {
            String lbAddrAuthority = server.getAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY);
            if (lbAddrAuthority != null) {
                newLbAddressGroups.add(new LbAddressGroup(server, lbAddrAuthority));
                continue;
            }
            newBackendServers.add(server);
        }
        newLbAddressGroups = Collections.unmodifiableList(newLbAddressGroups);
        newBackendServers = Collections.unmodifiableList(newBackendServers);
        Map rawLbConfigValue = (Map)attributes.get(ATTR_LOAD_BALANCING_CONFIG);
        GrpclbState.Mode newMode = GrpclbLoadBalancer.retrieveModeFromLbConfig(rawLbConfigValue, this.helper.getChannelLogger());
        if (!this.mode.equals((Object)newMode)) {
            this.mode = newMode;
            this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Mode: " + (Object)((Object)newMode));
            this.recreateStates();
        }
        this.grpclbState.handleAddresses(newLbAddressGroups, newBackendServers);
    }

    @Override
    public void requestConnection() {
        if (this.grpclbState != null) {
            this.grpclbState.requestConnection();
        }
    }

    @VisibleForTesting
    static GrpclbState.Mode retrieveModeFromLbConfig(@Nullable Map<String, ?> rawLbConfigValue, ChannelLogger channelLogger) {
        try {
            if (rawLbConfigValue == null) {
                return DEFAULT_MODE;
            }
            List<?> rawChildPolicies = GrpclbLoadBalancer.getList(rawLbConfigValue, "childPolicy");
            if (rawChildPolicies == null) {
                return DEFAULT_MODE;
            }
            List<ServiceConfigUtil.LbConfig> childPolicies = ServiceConfigUtil.unwrapLoadBalancingConfigList(GrpclbLoadBalancer.checkObjectList(rawChildPolicies));
            for (ServiceConfigUtil.LbConfig childPolicy : childPolicies) {
                String childPolicyName;
                switch (childPolicyName = childPolicy.getPolicyName()) {
                    case "round_robin": {
                        return GrpclbState.Mode.ROUND_ROBIN;
                    }
                    case "pick_first": {
                        return GrpclbState.Mode.PICK_FIRST;
                    }
                }
                channelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "grpclb ignoring unsupported child policy " + childPolicyName);
            }
        }
        catch (RuntimeException e) {
            channelLogger.log(ChannelLogger.ChannelLogLevel.WARNING, "Bad grpclb config, using " + (Object)((Object)DEFAULT_MODE));
            logger.log(Level.WARNING, "Bad grpclb config: " + rawLbConfigValue + ", using " + (Object)((Object)DEFAULT_MODE), e);
        }
        return DEFAULT_MODE;
    }

    private void resetStates() {
        if (this.grpclbState != null) {
            this.grpclbState.shutdown();
            this.grpclbState = null;
        }
    }

    private void recreateStates() {
        this.resetStates();
        Preconditions.checkState(this.grpclbState == null, "Should've been cleared");
        this.grpclbState = new GrpclbState(this.mode, this.helper, this.subchannelPool, this.time, this.stopwatch, this.backoffPolicyProvider, this.pickFirstIndex);
    }

    @Override
    public void shutdown() {
        this.resetStates();
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.grpclbState != null) {
            this.grpclbState.propagateError(error);
        }
    }

    @Nullable
    @VisibleForTesting
    GrpclbState getGrpclbState() {
        return this.grpclbState;
    }

    @Nullable
    private static List<?> getList(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof List)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in %s is not List", value, key, obj));
        }
        return (List)value;
    }

    private static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof Map) continue;
            throw new ClassCastException(String.format("value %s for idx %d in %s is not object", rawList.get(i), i, rawList));
        }
        return rawList;
    }
}

