/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.opencensus.trace;

import io.etcd.jetcd.shaded.io.opencensus.common.Clock;
import io.etcd.jetcd.shaded.io.opencensus.internal.Provider;
import io.etcd.jetcd.shaded.io.opencensus.trace.TraceComponent;
import io.etcd.jetcd.shaded.io.opencensus.trace.Tracer;
import io.etcd.jetcd.shaded.io.opencensus.trace.config.TraceConfig;
import io.etcd.jetcd.shaded.io.opencensus.trace.export.ExportComponent;
import io.etcd.jetcd.shaded.io.opencensus.trace.propagation.PropagationComponent;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Tracing {
    private static final Logger logger = Logger.getLogger(Tracing.class.getName());
    private static final TraceComponent traceComponent = Tracing.loadTraceComponent(TraceComponent.class.getClassLoader());

    public static Tracer getTracer() {
        return traceComponent.getTracer();
    }

    public static PropagationComponent getPropagationComponent() {
        return traceComponent.getPropagationComponent();
    }

    public static Clock getClock() {
        return traceComponent.getClock();
    }

    public static ExportComponent getExportComponent() {
        return traceComponent.getExportComponent();
    }

    public static TraceConfig getTraceConfig() {
        return traceComponent.getTraceConfig();
    }

    static TraceComponent loadTraceComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("io.etcd.jetcd.shaded.io.opencensus.impl.trace.TraceComponentImpl", true, classLoader), TraceComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for TraceComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("io.etcd.jetcd.shaded.io.opencensus.impllite.trace.TraceComponentImplLite", true, classLoader), TraceComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for TraceComponent, now using default implementation for TraceComponent.", e2);
                return TraceComponent.newNoopTraceComponent();
            }
        }
    }

    private Tracing() {
    }
}

