/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.inprocess;

import io.etcd.jetcd.shaded.com.google.common.base.MoreObjects;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.InternalChannelz;
import io.etcd.jetcd.shaded.io.grpc.InternalInstrumented;
import io.etcd.jetcd.shaded.io.grpc.ServerStreamTracer;
import io.etcd.jetcd.shaded.io.grpc.inprocess.InProcessServerBuilder;
import io.etcd.jetcd.shaded.io.grpc.inprocess.InProcessTransport;
import io.etcd.jetcd.shaded.io.grpc.internal.InternalServer;
import io.etcd.jetcd.shaded.io.grpc.internal.ObjectPool;
import io.etcd.jetcd.shaded.io.grpc.internal.ServerListener;
import io.etcd.jetcd.shaded.io.grpc.internal.ServerTransportListener;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;

@ThreadSafe
final class InProcessServer
implements InternalServer {
    private static final ConcurrentMap<String, InProcessServer> registry = new ConcurrentHashMap<String, InProcessServer>();
    private final String name;
    private final int maxInboundMetadataSize;
    private final List<ServerStreamTracer.Factory> streamTracerFactories;
    private ServerListener listener;
    private boolean shutdown;
    private final ObjectPool<ScheduledExecutorService> schedulerPool;
    private ScheduledExecutorService scheduler;

    static InProcessServer findServer(String name) {
        return (InProcessServer)registry.get(name);
    }

    InProcessServer(InProcessServerBuilder builder, List<ServerStreamTracer.Factory> streamTracerFactories) {
        this.name = builder.name;
        this.schedulerPool = builder.schedulerPool;
        this.maxInboundMetadataSize = builder.maxInboundMetadataSize;
        this.streamTracerFactories = Collections.unmodifiableList(Preconditions.checkNotNull(streamTracerFactories, "streamTracerFactories"));
    }

    @Override
    public void start(ServerListener serverListener) throws IOException {
        this.listener = serverListener;
        this.scheduler = this.schedulerPool.getObject();
        if (registry.putIfAbsent(this.name, this) != null) {
            throw new IOException("name already registered: " + this.name);
        }
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public List<InternalInstrumented<InternalChannelz.SocketStats>> getListenSockets() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!registry.remove(this.name, this)) {
            throw new AssertionError();
        }
        this.scheduler = this.schedulerPool.returnObject(this.scheduler);
        InProcessServer inProcessServer = this;
        synchronized (inProcessServer) {
            this.shutdown = true;
            this.listener.serverShutdown();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }

    synchronized ServerTransportListener register(InProcessTransport transport) {
        if (this.shutdown) {
            return null;
        }
        return this.listener.transportCreated(transport);
    }

    ObjectPool<ScheduledExecutorService> getScheduledExecutorServicePool() {
        return this.schedulerPool;
    }

    int getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    List<ServerStreamTracer.Factory> getStreamTracerFactories() {
        return this.streamTracerFactories;
    }
}

