/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.grpclb;

import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.SynchronizationContext;
import io.etcd.jetcd.shaded.io.grpc.grpclb.SubchannelPool;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

final class CachedSubchannelPool
implements SubchannelPool {
    private final HashMap<EquivalentAddressGroup, CacheEntry> cache = new HashMap();
    private LoadBalancer.Helper helper;
    @VisibleForTesting
    static final long SHUTDOWN_TIMEOUT_MS = 10000L;

    CachedSubchannelPool() {
    }

    @Override
    public void init(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
    }

    @Override
    public LoadBalancer.Subchannel takeOrCreateSubchannel(EquivalentAddressGroup eag, Attributes defaultAttributes) {
        LoadBalancer.Subchannel subchannel;
        CacheEntry entry = this.cache.remove(eag);
        if (entry == null) {
            subchannel = this.helper.createSubchannel(eag, defaultAttributes);
        } else {
            subchannel = entry.subchannel;
            entry.shutdownTimer.cancel();
        }
        return subchannel;
    }

    @Override
    public void returnSubchannel(LoadBalancer.Subchannel subchannel) {
        CacheEntry prev = this.cache.get(subchannel.getAddresses());
        if (prev != null) {
            if (prev.subchannel != subchannel) {
                subchannel.shutdown();
            }
            return;
        }
        ShutdownSubchannelTask shutdownTask = new ShutdownSubchannelTask(subchannel);
        SynchronizationContext.ScheduledHandle shutdownTimer = this.helper.getSynchronizationContext().schedule(shutdownTask, 10000L, TimeUnit.MILLISECONDS, this.helper.getScheduledExecutorService());
        CacheEntry entry = new CacheEntry(subchannel, shutdownTimer);
        this.cache.put(subchannel.getAddresses(), entry);
    }

    @Override
    public void clear() {
        for (CacheEntry entry : this.cache.values()) {
            entry.shutdownTimer.cancel();
            entry.subchannel.shutdown();
        }
        this.cache.clear();
    }

    private static class CacheEntry {
        final LoadBalancer.Subchannel subchannel;
        final SynchronizationContext.ScheduledHandle shutdownTimer;

        CacheEntry(LoadBalancer.Subchannel subchannel, SynchronizationContext.ScheduledHandle shutdownTimer) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
            this.shutdownTimer = Preconditions.checkNotNull(shutdownTimer, "shutdownTimer");
        }
    }

    @VisibleForTesting
    final class ShutdownSubchannelTask
    implements Runnable {
        private final LoadBalancer.Subchannel subchannel;

        private ShutdownSubchannelTask(LoadBalancer.Subchannel subchannel) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
        }

        @Override
        public void run() {
            CacheEntry entry = (CacheEntry)CachedSubchannelPool.this.cache.remove(this.subchannel.getAddresses());
            Preconditions.checkState(entry.subchannel == this.subchannel, "Inconsistent state");
            this.subchannel.shutdown();
        }
    }
}

