/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc;

import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.ExperimentalApi;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancerProvider;
import io.etcd.jetcd.shaded.io.grpc.ServiceProviders;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
public final class LoadBalancerRegistry {
    private static final Logger logger = Logger.getLogger(LoadBalancerRegistry.class.getName());
    private static LoadBalancerRegistry instance;
    private static final Iterable<Class<?>> HARDCODED_CLASSES;
    private final Map<String, LoadBalancerProvider> providers;

    @VisibleForTesting
    LoadBalancerRegistry(List<LoadBalancerProvider> providerList) {
        LinkedHashMap<String, LoadBalancerProvider> providerMap = new LinkedHashMap<String, LoadBalancerProvider>();
        for (LoadBalancerProvider provider : providerList) {
            if (!provider.isAvailable()) {
                logger.fine(provider + " found but not available");
                continue;
            }
            String policy = provider.getPolicyName();
            LoadBalancerProvider existing = (LoadBalancerProvider)providerMap.get(policy);
            if (existing == null) {
                logger.fine("Found " + provider);
                providerMap.put(policy, provider);
                continue;
            }
            if (existing.getPriority() < provider.getPriority()) {
                logger.fine(provider + " overrides " + existing + " because of higher priority");
                providerMap.put(policy, provider);
                continue;
            }
            if (existing.getPriority() > provider.getPriority()) {
                logger.fine(provider + " doesn't override " + existing + " because of lower priority");
                continue;
            }
            LoadBalancerProvider selected = existing;
            if (existing.getClass().getName().compareTo(provider.getClass().getName()) < 0) {
                providerMap.put(policy, provider);
                selected = provider;
            }
            logger.warning(provider + " and " + existing + " has the same priority. " + selected + " is selected for this time. You should make them differ in either policy name or priority, or remove one of them from your classpath");
        }
        this.providers = Collections.unmodifiableMap(providerMap);
    }

    public static synchronized LoadBalancerRegistry getDefaultRegistry() {
        if (instance == null) {
            List<LoadBalancerProvider> providerList = ServiceProviders.loadAll(LoadBalancerProvider.class, HARDCODED_CLASSES, LoadBalancerProvider.class.getClassLoader(), new LoadBalancerPriorityAccessor());
            instance = new LoadBalancerRegistry(providerList);
        }
        return instance;
    }

    @Nullable
    public LoadBalancerProvider getProvider(String policy) {
        return this.providers.get(Preconditions.checkNotNull(policy, "policy"));
    }

    @VisibleForTesting
    Map<String, LoadBalancerProvider> providers() {
        return this.providers;
    }

    @VisibleForTesting
    static List<Class<?>> getHardCodedClasses() {
        ArrayList list = new ArrayList();
        try {
            list.add(Class.forName("io.etcd.jetcd.shaded.io.grpc.internal.PickFirstLoadBalancerProvider"));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Unable to find pick-first LoadBalancer", e);
        }
        try {
            list.add(Class.forName("io.etcd.jetcd.shaded.io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider"));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Unable to find round-robin LoadBalancer", e);
        }
        return Collections.unmodifiableList(list);
    }

    static {
        HARDCODED_CLASSES = LoadBalancerRegistry.getHardCodedClasses();
    }

    private static final class LoadBalancerPriorityAccessor
    implements ServiceProviders.PriorityAccessor<LoadBalancerProvider> {
        LoadBalancerPriorityAccessor() {
        }

        @Override
        public boolean isAvailable(LoadBalancerProvider provider) {
            return provider.isAvailable();
        }

        @Override
        public int getPriority(LoadBalancerProvider provider) {
            return provider.getPriority();
        }
    }
}

