/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.shaded.com.google.common.util.concurrent.FutureCallback;
import io.etcd.jetcd.shaded.com.google.common.util.concurrent.Futures;
import io.etcd.jetcd.shaded.com.google.common.util.concurrent.ListenableFuture;
import io.etcd.jetcd.shaded.io.grpc.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class Util {
    private Util() {
    }

    public static List<URI> toURIs(Collection<String> uris) {
        return uris.stream().map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid endpoint URI: " + uri, e);
            }
        }).collect(Collectors.toList());
    }

    static <S, T> CompletableFuture<T> toCompletableFuture(final ListenableFuture<S> sourceFuture, Function<S, T> resultConvert, Executor executor) {
        CompletableFuture targetFuture = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                super.cancel(mayInterruptIfRunning);
                return sourceFuture.cancel(mayInterruptIfRunning);
            }
        };
        sourceFuture.addListener(() -> {
            try {
                targetFuture.complete(resultConvert.apply(sourceFuture.get()));
            }
            catch (Exception e) {
                targetFuture.completeExceptionally(EtcdExceptionFactory.toEtcdException(e));
            }
        }, executor);
        return targetFuture;
    }

    static <S, T> CompletableFuture<T> toCompletableFutureWithRetry(Supplier<ListenableFuture<S>> newSourceFuture, Function<S, T> resultConvert, Executor executor) {
        return Util.toCompletableFutureWithRetry(newSourceFuture, resultConvert, Util::isRetriable, executor);
    }

    static <S, T> CompletableFuture<T> toCompletableFutureWithRetry(Supplier<ListenableFuture<S>> newSourceFuture, Function<S, T> resultConvert, Function<Exception, Boolean> doRetry, Executor executor) {
        final AtomicReference sourceFutureRef = new AtomicReference();
        sourceFutureRef.lazySet(newSourceFuture.get());
        CompletableFuture targetFuture = new CompletableFuture<T>(){

            @Override
            public synchronized boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelled = super.cancel(mayInterruptIfRunning);
                ListenableFuture sourceFuture = (ListenableFuture)sourceFutureRef.get();
                if (sourceFuture != null) {
                    cancelled = sourceFuture.cancel(true);
                }
                return cancelled;
            }
        };
        executor.execute(() -> {
            int retryLimit = 3;
            while (retryLimit-- > 0) {
                try {
                    ListenableFuture f = (ListenableFuture)sourceFutureRef.get();
                    targetFuture.complete(resultConvert.apply(f.get()));
                    return;
                }
                catch (Exception e) {
                    if (((Boolean)doRetry.apply(e)).booleanValue()) {
                        CompletableFuture completableFuture = targetFuture;
                        synchronized (completableFuture) {
                            if (targetFuture.isCancelled()) {
                                return;
                            }
                            sourceFutureRef.set((ListenableFuture)newSourceFuture.get());
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            targetFuture.completeExceptionally(EtcdExceptionFactory.handleInterrupt(e1));
                            return;
                        }
                    }
                    targetFuture.completeExceptionally(e);
                    return;
                }
            }
            targetFuture.completeExceptionally(EtcdExceptionFactory.newEtcdException(ErrorCode.ABORTED, "maximum number of auto retries reached"));
        });
        return targetFuture;
    }

    static boolean isRetriable(Exception e) {
        return Util.isInvalidTokenError(Status.fromThrowable(e));
    }

    static boolean isInvalidTokenError(Status status) {
        return status.getCode() == Status.Code.UNAUTHENTICATED && "etcdserver: invalid auth token".equals(status.getDescription());
    }

    static <T> void applyIfNotNull(T target, Consumer<T> consumer) {
        if (target != null) {
            consumer.accept(target);
        }
    }

    static <T> T supplyIfNull(T target, Supplier<T> supplier) {
        return target != null ? target : supplier.get();
    }

    static void addOnFailureLoggingCallback(Executor executor, ListenableFuture<?> listenableFuture, final Logger callerLogger, final String message) {
        Futures.addCallback(listenableFuture, new FutureCallback<Object>(){

            @Override
            public void onFailure(Throwable throwable) {
                callerLogger.error(message, throwable);
            }

            @Override
            public void onSuccess(Object result) {
            }
        }, executor);
    }

    static boolean isNoLeaderError(Status status) {
        return status.getCode() == Status.Code.UNAVAILABLE && "etcdserver: no leader".equals(status.getDescription());
    }

    static boolean isHaltError(Status status) {
        return status.getCode() != Status.Code.UNAVAILABLE && status.getCode() != Status.Code.INTERNAL;
    }
}

