/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.NetworkUtils;
import esa.commons.StringUtils;
import esa.commons.annotation.Internal;
import esa.commons.http.HttpVersion;
import esa.commons.logging.Logger;
import esa.commons.logging.LoggerFactory;
import esa.httpserver.core.AsyncRequest;
import esa.httpserver.core.HttpInputStream;
import esa.httpserver.core.Request;
import esa.httpserver.impl.ByteBufHttpInputStream;
import esa.restlight.core.util.MediaType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public class AsyncRequestImpl
implements AsyncRequest {
    private static final Logger logger = LoggerFactory.getLogger(AsyncRequestImpl.class);
    private static final io.netty.handler.codec.http.HttpVersion HTTP2 = new io.netty.handler.codec.http.HttpVersion("HTTP", 2, 0, true);
    private final ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();
    private final Request req;
    private final HttpMethod method;
    private final HttpHeaders headers;
    private final HttpHeaders trailers;
    private Map<String, List<String>> params;
    private HttpInputStream is;
    private Set<Cookie> cookies;

    public AsyncRequestImpl(Request req) {
        Map.Entry entry;
        Iterator it;
        this.req = req;
        this.method = HttpMethod.valueOf((String)req.rawMethod());
        if (req.headers() instanceof HttpHeaders) {
            this.headers = (HttpHeaders)req.headers();
        } else {
            this.headers = new DefaultHttpHeaders();
            it = req.headers().iteratorCharSequence();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                this.headers.add((CharSequence)entry.getKey(), entry.getValue());
            }
        }
        if (req.aggregated().trailers().isEmpty()) {
            this.trailers = EmptyHttpHeaders.INSTANCE;
        } else if (req.aggregated().trailers() instanceof HttpHeaders) {
            this.trailers = (HttpHeaders)req.aggregated().trailers();
        } else {
            this.trailers = new DefaultHttpHeaders();
            it = req.aggregated().trailers().iteratorCharSequence();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                this.trailers.add((CharSequence)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public io.netty.handler.codec.http.HttpVersion httpVersion() {
        if (this.req.version() == HttpVersion.HTTP_1_1) {
            return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
        }
        if (this.req.version() == HttpVersion.HTTP_1_0) {
            return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
        }
        return HTTP2;
    }

    @Override
    public String scheme() {
        return this.req.scheme();
    }

    @Override
    public String uri() {
        return this.req.uri();
    }

    @Override
    public String path() {
        return this.req.path();
    }

    @Override
    public String query() {
        return this.req.query();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public HttpHeaders trailers() {
        return this.trailers;
    }

    @Override
    public ByteBuf byteBufBody() {
        return this.req.aggregated().body();
    }

    @Override
    public HttpInputStream inputStream() {
        if (this.is == null) {
            this.is = new ByteBufHttpInputStream(this.byteBufBody(), false);
        }
        return this.is;
    }

    @Override
    public String remoteAddr() {
        return AsyncRequestImpl.getHostAddress(this.req.remoteAddress());
    }

    @Override
    public String tcpSourceAddr() {
        return AsyncRequestImpl.getHostAddress(this.req.tcpSourceAddress());
    }

    @Override
    public int remotePort() {
        return NetworkUtils.getPort((SocketAddress)this.req.remoteAddress());
    }

    @Override
    public String localAddr() {
        return AsyncRequestImpl.getHostAddress(this.req.localAddress());
    }

    @Override
    public int localPort() {
        return NetworkUtils.getPort((SocketAddress)this.req.localAddress());
    }

    @Override
    public Map<String, List<String>> parameterMap() {
        if (this.params == null) {
            String contentType;
            Map decoded = this.req.paramMap();
            if (esa.commons.http.HttpMethod.POST.equals((Object)this.req.method()) && this.byteBufBody().isReadable() && (contentType = this.req.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null && contentType.length() >= "application/x-www-form-urlencoded".length() && contentType.charAt(0) == "application/x-www-form-urlencoded".charAt(0)) {
                MediaType mediaType = null;
                try {
                    mediaType = MediaType.valueOf((String)contentType);
                }
                catch (Exception e) {
                    logger.warn("Error while parsing content type: " + contentType, (Throwable)e);
                }
                if (mediaType != null && mediaType.isCompatibleWith(MediaType.APPLICATION_FORM_URLENCODED)) {
                    Charset charset = mediaType.charset();
                    if (charset == null) {
                        charset = StandardCharsets.UTF_8;
                    }
                    String body = this.byteBufBody().toString(charset);
                    QueryStringDecoder decoder = new QueryStringDecoder(body, false);
                    Map bodyParam = null;
                    try {
                        bodyParam = decoder.parameters();
                    }
                    catch (Exception e) {
                        logger.warn("Error while parsing body parameter, body: " + body, (Throwable)e);
                    }
                    if (bodyParam != null && !bodyParam.isEmpty()) {
                        bodyParam.putAll(decoded);
                        decoded = bodyParam;
                    }
                }
            }
            this.params = decoded;
        }
        return this.params;
    }

    @Override
    public Set<Cookie> cookies() {
        if (this.cookies == null) {
            String value = this.headers().get((CharSequence)HttpHeaderNames.COOKIE);
            this.cookies = value == null ? Collections.emptySet() : ServerCookieDecoder.STRICT.decode(value);
        }
        return this.cookies;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    @Override
    public String[] attributeNames() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.attributes.keySet())).toArray(new String[0]);
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.req.alloc();
    }

    public String toString() {
        return this.req.toString();
    }

    private static String getHostAddress(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            String addr;
            InetSocketAddress socketAddress = (InetSocketAddress)address;
            InetAddress inet = socketAddress.getAddress();
            if (inet != null && (addr = inet.getHostAddress()) != null) {
                return addr;
            }
        } else if (address instanceof DomainSocketAddress) {
            return NetworkUtils.parseAddress((SocketAddress)address);
        }
        return StringUtils.empty();
    }
}

