/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.core;

import esa.commons.Checks;
import esa.commons.annotation.Beta;
import esa.httpserver.core.HttpOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public interface AsyncResponse {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public void setStatus(int var1);

    public int status();

    public boolean isKeepAlive();

    public HttpOutputStream outputStream();

    public void setBufferSize(int var1);

    public int bufferSize();

    public boolean isCommitted();

    public void reset();

    public void sendResult(byte[] var1, int var2, int var3);

    default public void sendResult(int code, byte[] body, int off, int len) {
        this.setStatus(code);
        this.sendResult(body, off, len);
    }

    default public void sendResult(byte[] body) {
        this.sendResult(body, 0, body == null ? 0 : body.length);
    }

    default public void sendResult(int code, byte[] body) {
        this.setStatus(code);
        this.sendResult(body);
    }

    default public void sendResult(int code) {
        this.sendResult(code, (byte[])null);
    }

    default public void sendResult() {
        this.sendResult((byte[])null);
    }

    public void sendResult(ByteBuf var1, int var2, int var3, boolean var4);

    default public void sendResult(int code, ByteBuf body, int off, int len, boolean autoRelease) {
        this.setStatus(code);
        this.sendResult(body, off, len, autoRelease);
    }

    default public void sendResult(int code, ByteBuf body, int off, int len) {
        this.sendResult(code, body, off, len, true);
    }

    default public void sendResult(ByteBuf body, int off, int len) {
        this.sendResult(body, off, len, true);
    }

    default public void sendResult(ByteBuf body, boolean autoRelease) {
        if (body == null) {
            this.sendResult(body, 0, 0, autoRelease);
        } else {
            this.sendResult(body, body.readerIndex(), body.capacity(), autoRelease);
        }
    }

    default public void sendResult(int code, ByteBuf body, boolean autoRelease) {
        this.setStatus(code);
        this.sendResult(body, autoRelease);
    }

    default public void sendResult(int code, ByteBuf body) {
        this.sendResult(code, body, true);
    }

    default public void sendResult(ByteBuf body) {
        this.sendResult(body, true);
    }

    default public void sendRedirect(String newUri) {
        Checks.checkNotEmptyArg((String)newUri);
        this.setHeader((CharSequence)HttpHeaderNames.LOCATION, newUri);
        this.sendResult(HttpResponseStatus.FOUND.code());
    }

    default public void sendFile(File file) {
        this.sendFile(file, 0L);
    }

    default public void sendFile(File file, long offset) {
        this.sendFile(file, offset, Long.MAX_VALUE);
    }

    public void sendFile(File var1, long var2, long var4);

    @Beta
    public ByteBufAllocator alloc();

    default public String getHeader(String name) {
        return this.getHeader((CharSequence)name);
    }

    public String getHeader(CharSequence var1);

    public Collection<String> headerNames();

    public Collection<String> getHeaders(CharSequence var1);

    default public Collection<String> getHeaders(String name) {
        return this.getHeaders((CharSequence)name);
    }

    public boolean containsHeader(CharSequence var1);

    default public boolean containsHeader(String name) {
        return this.containsHeader((CharSequence)name);
    }

    public void addHeader(CharSequence var1, String var2);

    default public void addHeader(String name, String value) {
        this.addHeader((CharSequence)name, value);
    }

    public void setHeader(CharSequence var1, String var2);

    default public void setHeader(String name, String value) {
        this.setHeader((CharSequence)name, value);
    }

    public void setHeaders(CharSequence var1, List<String> var2);

    default public void setHeaders(String name, List<String> values) {
        this.setHeaders((CharSequence)name, values);
    }

    public void setIntHeader(CharSequence var1, int var2);

    default public void setIntHeader(String name, int value) {
        this.setIntHeader((CharSequence)name, value);
    }

    public void addIntHeader(CharSequence var1, int var2);

    default public void addIntHeader(String name, int value) {
        this.addIntHeader((CharSequence)name, value);
    }

    public void setShortHeader(CharSequence var1, short var2);

    default public void setShortHeader(String name, short value) {
        this.setShortHeader((CharSequence)name, value);
    }

    public void addShortHeader(CharSequence var1, short var2);

    default public void addShortHeader(String name, short value) {
        this.addShortHeader((CharSequence)name, value);
    }

    public void addTrailer(CharSequence var1, String var2);

    default public void addTrailer(String name, String value) {
        this.addTrailer((CharSequence)name, value);
    }

    public void setTrailer(CharSequence var1, String var2);

    default public void setTrailer(String name, String value) {
        this.setTrailer((CharSequence)name, value);
    }

    public void setTrailers(CharSequence var1, List<String> var2);

    default public void setTrailers(String name, List<String> values) {
        this.setTrailers((CharSequence)name, values);
    }

    public void addCookie(Cookie var1);

    public void addCookie(String var1, String var2);

    public void onEnd(Consumer<AsyncResponse> var1);

    @Deprecated
    default public void addEndListener(EndListener endListener) {
        this.onEnd(endListener::onEnd);
    }

    @Deprecated
    default public int getStatus() {
        return this.status();
    }

    @Deprecated
    default public HttpOutputStream getOutputStream() {
        return this.outputStream();
    }

    @Deprecated
    default public int getBufferSize() {
        return this.bufferSize();
    }

    @Deprecated
    default public Collection<String> getHeaderNames() {
        return this.headerNames();
    }

    @Deprecated
    public static interface EndListener {
        public void onEnd(AsyncResponse var1);
    }
}

