/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.Checks;
import esa.commons.ExceptionUtils;
import esa.httpserver.core.HttpOutputStream;
import esa.httpserver.core.Response;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ByteBufHttpOutputStream
extends HttpOutputStream {
    private static final int MIN_BUFFER_SIZE = 8;
    private final ByteBuf byteBuf;
    private final Response resp;
    private volatile int closed;
    private static final AtomicIntegerFieldUpdater<ByteBufHttpOutputStream> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ByteBufHttpOutputStream.class, "closed");

    ByteBufHttpOutputStream(int bufferSize, Response resp) {
        if (bufferSize < 8) {
            throw new IllegalArgumentException("buffer size must be over than 8. actual: " + bufferSize);
        }
        this.byteBuf = resp.alloc().buffer(0, bufferSize);
        this.resp = resp;
    }

    @Override
    public void write(int b) {
        this.checkCloseState();
        this.ensureSpace(1);
        this.byteBuf.writeByte(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        Checks.checkNotNull((Object)b, (String)"b");
        if (MathUtil.isOutOfBounds((int)off, (int)len, (int)b.length)) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.checkCloseState();
        this.write0(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.checkCloseState();
        this.ensureSpace(1);
        this.byteBuf.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) {
        this.checkCloseState();
        this.ensureSpace(1);
        this.byteBuf.writeByte(v);
    }

    @Override
    public void writeShort(int v) {
        this.checkCloseState();
        this.ensureSpace(2);
        this.byteBuf.writeShort(v);
    }

    @Override
    public void writeChar(int v) {
        this.checkCloseState();
        this.ensureSpace(2);
        this.byteBuf.writeChar(v);
    }

    @Override
    public void writeInt(int v) {
        this.checkCloseState();
        this.ensureSpace(4);
        this.byteBuf.writeInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.checkCloseState();
        this.ensureSpace(8);
        this.byteBuf.writeLong(v);
    }

    @Override
    public void writeFloat(float v) {
        this.checkCloseState();
        this.ensureSpace(4);
        this.byteBuf.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        this.checkCloseState();
        this.ensureSpace(8);
        this.byteBuf.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        int writable;
        this.checkNullAndCloseState(s);
        int len = s.length();
        int off = 0;
        while ((writable = this.byteBuf.maxWritableBytes()) < len) {
            this.writeAscii0(s, off, writable);
            len -= writable;
            off += writable;
            this.flush(false);
        }
        if (len > 0) {
            this.writeAscii0(s, off, len);
        }
    }

    @Override
    public void writeChars(String s) {
        int writable;
        this.checkNullAndCloseState(s);
        int len = s.length();
        int off = 0;
        while ((writable = this.byteBuf.maxWritableBytes() / 2) < len) {
            this.writeChars0(s, off, writable);
            len -= writable;
            off += writable;
            this.flush(false);
        }
        if (len > 0) {
            this.writeChars0(s, off, len);
        }
    }

    @Override
    public void writeUTF(String s) {
        this.checkNullAndCloseState(s);
        int len = ByteBufUtil.utf8MaxBytes((CharSequence)s);
        if (len > this.byteBuf.maxCapacity()) {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            this.write0(bytes, 0, bytes.length);
        } else {
            this.ensureSpace(len);
            this.byteBuf.writeCharSequence((CharSequence)s, CharsetUtil.UTF_8);
        }
    }

    @Override
    public void flush() {
        if (this.isClosed()) {
            return;
        }
        this.flush(false);
    }

    @Override
    public void close() {
        if (!CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            return;
        }
        this.flush(true);
        this.resp.end();
    }

    @Override
    public boolean isClosed() {
        return this.closed == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean isLast) {
        if (this.byteBuf.readableBytes() == 0) {
            if (isLast) {
                this.byteBuf.release();
            }
            return;
        }
        if (isLast) {
            this.resp.write(this.byteBuf);
        } else {
            ByteBuf copy = this.byteBuf.copy();
            try {
                this.resp.write(copy);
            }
            catch (Exception e) {
                copy.release();
                ExceptionUtils.throwException((Throwable)e);
            }
            finally {
                this.byteBuf.clear();
            }
        }
    }

    private void checkNullAndCloseState(String s) {
        Checks.checkNotNull((Object)s, (String)"s");
        this.checkCloseState();
    }

    private void checkCloseState() {
        if (this.isClosed()) {
            throw new IllegalStateException("Output stream already closed");
        }
    }

    private void write0(byte[] b, int off, int len) {
        int writable;
        while ((writable = this.byteBuf.maxWritableBytes()) < len) {
            this.byteBuf.writeBytes(b, off, writable);
            len -= writable;
            off += writable;
            this.flush(false);
        }
        if (len > 0) {
            this.byteBuf.writeBytes(b, off, len);
        }
    }

    private void ensureSpace(int space) {
        if (this.byteBuf.maxWritableBytes() < space && this.byteBuf.capacity() > 0) {
            this.flush(false);
        }
    }

    private void writeAscii0(CharSequence seq, int off, int len) {
        int max = off + len;
        for (int i = off; i < max; ++i) {
            this.byteBuf.writeByte((int)AsciiString.c2b((char)seq.charAt(i)));
        }
    }

    private void writeChars0(CharSequence seq, int off, int len) {
        int max = off + len;
        for (int i = off; i < max; ++i) {
            this.byteBuf.writeChar((int)seq.charAt(i));
        }
    }
}

