/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.Checks;
import esa.commons.ExceptionUtils;
import esa.commons.annotation.Internal;
import esa.commons.netty.http.CookieImpl;
import esa.httpserver.core.AsyncResponse;
import esa.httpserver.core.HttpOutputStream;
import esa.httpserver.core.Response;
import esa.httpserver.impl.ByteBufHttpOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.internal.MathUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

@Internal
public class AsyncResponseImpl
implements AsyncResponse {
    private final Response res;
    private int bufferSize = 4096;
    private HttpOutputStream os;

    public AsyncResponseImpl(Response res) {
        this.res = res;
    }

    @Override
    public void setStatus(int code) {
        this.res.setStatus(code);
    }

    @Override
    public int status() {
        return this.res.status();
    }

    @Override
    public boolean isKeepAlive() {
        return this.res.isKeepAlive();
    }

    @Override
    public HttpOutputStream outputStream() {
        if (this.res.isEnded()) {
            throw new IllegalStateException("Already ended");
        }
        if (this.os == null) {
            this.checkCommitted();
            this.os = new ByteBufHttpOutputStream(this.bufferSize, this.res);
        }
        return this.os;
    }

    @Override
    public void setBufferSize(int size) {
        if (this.isCommitted() || this.os != null) {
            return;
        }
        Checks.checkArg((size > 0 ? 1 : 0) != 0, (String)("buffer size must be over than 0. actual: " + size));
        this.bufferSize = size;
    }

    @Override
    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean isCommitted() {
        return this.res.isCommitted();
    }

    @Override
    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed.");
        }
        this.res.setStatus(200);
        this.setBufferSize(4096);
        this.res.headers().clear();
        this.res.trailers().clear();
    }

    @Override
    public void sendResult(byte[] body, int off, int len) {
        this.checkOutputStream();
        this.res.end(body, off, len);
    }

    @Override
    public void sendResult(byte[] body) {
        this.checkOutputStream();
        this.res.end(body);
    }

    @Override
    public void sendResult(ByteBuf body, boolean autoRelease) {
        this.checkOutputStream();
        if (autoRelease) {
            this.res.end(body);
        } else {
            try {
                this.res.end(body.retain());
            }
            catch (Exception e) {
                body.release();
                ExceptionUtils.throwException((Throwable)e);
            }
        }
    }

    @Override
    public void sendResult(ByteBuf body, int off, int len, boolean autoRelease) {
        this.checkOutputStream();
        if (body == null) {
            body = Unpooled.EMPTY_BUFFER;
        }
        if (MathUtil.isOutOfBounds((int)off, (int)len, (int)body.capacity())) {
            throw new IndexOutOfBoundsException();
        }
        if (autoRelease) {
            this.res.end(body.slice(off, len));
        } else {
            try {
                this.res.end(body.retainedSlice(off, len));
            }
            catch (Exception e) {
                body.release();
                ExceptionUtils.throwException((Throwable)e);
            }
        }
    }

    @Override
    public void sendFile(File file, long offset, long length) {
        this.checkOutputStream();
        this.res.sendFile(file, offset, length);
    }

    @Override
    public void sendRedirect(String newUri) {
        this.checkOutputStream();
        this.res.sendRedirect(newUri);
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.res.alloc();
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.res.headers().get(name);
    }

    @Override
    public Collection<String> headerNames() {
        return this.res.headers().names();
    }

    @Override
    public Collection<String> getHeaders(CharSequence name) {
        return this.res.headers().getAll(name);
    }

    @Override
    public boolean containsHeader(CharSequence name) {
        return this.res.headers().contains(name);
    }

    @Override
    public void addHeader(CharSequence name, String value) {
        this.res.headers().add(name, (Object)value);
    }

    @Override
    public void setHeader(CharSequence name, String value) {
        this.res.headers().set(name, (Object)value);
    }

    @Override
    public void setHeaders(CharSequence name, List<String> values) {
        this.res.headers().set(name, values);
    }

    @Override
    public void setIntHeader(CharSequence name, int value) {
        this.res.headers().setInt(name, value);
    }

    @Override
    public void addIntHeader(CharSequence name, int value) {
        this.res.headers().addInt(name, value);
    }

    @Override
    public void setShortHeader(CharSequence name, short value) {
        this.res.headers().setShort(name, value);
    }

    @Override
    public void addShortHeader(CharSequence name, short value) {
        this.res.headers().addShort(name, value);
    }

    @Override
    public void addTrailer(CharSequence name, String value) {
        this.res.trailers().add(name, (Object)value);
    }

    @Override
    public void setTrailer(CharSequence name, String value) {
        this.res.trailers().set(name, (Object)value);
    }

    @Override
    public void setTrailers(CharSequence name, List<String> values) {
        this.res.trailers().set(name, values);
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.res.addCookie((esa.commons.http.Cookie)new CookieImpl(cookie));
    }

    @Override
    public void addCookie(String name, String value) {
        this.res.addCookie(name, value);
    }

    @Override
    public void onEnd(Consumer<AsyncResponse> listener) {
        this.res.onEndFuture().addListener(f -> listener.accept(this));
    }

    public String toString() {
        return this.res.toString();
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed.");
        }
    }

    private void checkOutputStream() {
        if (this.os != null) {
            throw new IllegalStateException("OutputStream has already opened. use it please.");
        }
    }
}

