/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.core;

import esa.commons.annotation.Beta;
import esa.httpserver.core.HttpInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface AsyncRequest {
    default public String protocol() {
        return this.httpVersion().text();
    }

    public HttpVersion httpVersion();

    public String scheme();

    public String uri();

    public String path();

    public String query();

    public HttpMethod method();

    default public String rawMethod() {
        return this.method().name();
    }

    public HttpInputStream inputStream();

    default public byte[] body() {
        return ByteBufUtil.getBytes((ByteBuf)this.byteBufBody());
    }

    public ByteBuf byteBufBody();

    default public int contentLength() {
        return this.byteBufBody().readableBytes();
    }

    public String remoteAddr();

    public String tcpSourceAddr();

    public int remotePort();

    public String localAddr();

    public int localPort();

    default public String getParameter(String parName) {
        List<String> params = this.getParameters(parName);
        if (params != null && params.size() > 0) {
            return params.get(0);
        }
        return null;
    }

    default public List<String> getParameters(String parName) {
        return this.parameterMap().get(parName);
    }

    public Map<String, List<String>> parameterMap();

    public HttpHeaders headers();

    default public boolean containsHeader(CharSequence name) {
        return this.headers().contains(name);
    }

    default public boolean containsHeader(String name) {
        return this.containsHeader((CharSequence)name);
    }

    default public String getHeader(CharSequence name) {
        return this.headers().get(name);
    }

    default public String getHeader(String name) {
        return this.getHeader((CharSequence)name);
    }

    default public Integer getIntHeader(CharSequence name) {
        return this.headers().getInt(name);
    }

    default public Integer getIntHeader(String name) {
        return this.getIntHeader((CharSequence)name);
    }

    default public Short getShortHeader(CharSequence name) {
        return this.headers().getShort(name);
    }

    default public Short getShortHeader(String name) {
        return this.getShortHeader((CharSequence)name);
    }

    @Deprecated
    default public int headerSize() {
        int size = 0;
        for (Map.Entry header : this.headers().entries()) {
            String headerName = (String)header.getKey();
            String headerValue = (String)header.getValue();
            if (headerName == null) continue;
            size += headerName.length();
            if (headerValue == null) continue;
            size += headerValue.length();
        }
        return size;
    }

    public HttpHeaders trailers();

    default public boolean containsTrailer(CharSequence name) {
        return this.trailers().contains(name);
    }

    default public boolean containsTrailer(String name) {
        return this.containsTrailer((CharSequence)name);
    }

    default public String getTrailer(CharSequence name) {
        return this.trailers().get(name);
    }

    default public String getTrailer(String name) {
        return this.getTrailer((CharSequence)name);
    }

    default public Integer getIntTrailer(CharSequence name) {
        return this.trailers().getInt(name);
    }

    default public Integer getIntTrailer(String name) {
        return this.getIntTrailer((CharSequence)name);
    }

    default public Short getShortTrailer(CharSequence name) {
        return this.trailers().getShort(name);
    }

    default public Short getShortTrailer(String name) {
        return this.getShortTrailer((CharSequence)name);
    }

    public Set<Cookie> cookies();

    default public Cookie getCookie(String name) {
        Set<Cookie> cookies = this.cookies();
        for (Cookie cookie : cookies) {
            if (!cookie.name().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    default public <T> T getUncheckedAttribute(String name) {
        return (T)this.getAttribute(name);
    }

    public Object removeAttribute(String var1);

    default public <T> T removeUncheckedAttribute(String name) {
        return (T)this.removeAttribute(name);
    }

    default public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public String[] attributeNames();

    @Beta
    public ByteBufAllocator alloc();

    @Deprecated
    default public String getProtocol() {
        return this.httpVersion().text();
    }

    @Deprecated
    default public String getScheme() {
        return this.scheme();
    }

    @Deprecated
    default public String getRequestURI() {
        return this.path();
    }

    @Deprecated
    default public String getURIAndQueryString() {
        return this.uri();
    }

    @Deprecated
    default public String getMethod() {
        return this.rawMethod();
    }

    @Deprecated
    default public HttpHeaders getHttpHeaders() {
        return this.headers();
    }

    @Deprecated
    default public HttpInputStream getInputStream() {
        return this.inputStream();
    }

    @Deprecated
    default public byte[] getBody() {
        return ByteBufUtil.getBytes((ByteBuf)this.getBodyByteBuf());
    }

    @Deprecated
    default public ByteBuf getBodyByteBuf() {
        return this.byteBufBody();
    }

    @Deprecated
    default public int getContentLength() {
        return this.contentLength();
    }

    @Deprecated
    default public Map<String, List<String>> getParameterMap() {
        return this.parameterMap();
    }

    @Deprecated
    default public Set<Cookie> getCookies() {
        return this.cookies();
    }

    @Deprecated
    default public String getRemoteAddr() {
        return this.remoteAddr();
    }

    @Deprecated
    default public String getTcpSourceAddr() {
        return this.tcpSourceAddr();
    }

    @Deprecated
    default public int getLocalPort() {
        return this.localPort();
    }

    @Deprecated
    default public int getHeaderSize() {
        return this.headerSize();
    }

    @Deprecated
    default public String getLocalAddr() {
        return this.localAddr();
    }

    @Deprecated
    default public String[] getAttributeNames() {
        return this.attributeNames();
    }

    @Deprecated
    default public void setHeader(String name, String value) {
        this.setHeader((CharSequence)name, value);
    }

    @Deprecated
    default public void setHeader(CharSequence name, String value) {
        this.headers().set(name, (Object)value);
    }

    @Deprecated
    default public void addHeader(String name, String value) {
        this.addHeader((CharSequence)name, value);
    }

    @Deprecated
    default public void addHeader(CharSequence name, String value) {
        this.headers().add(name, (Object)value);
    }
}

