/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.wrappers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.ringojs.util.ScriptUtils;
import org.ringojs.wrappers.Binary;

public class Stream
extends ScriptableObject
implements Wrapper {
    private InputStream input;
    private OutputStream output;
    private boolean closed = false;
    private static final String CLASSNAME = "Stream";

    public Stream() {
        this.input = null;
        this.output = null;
    }

    public Stream(Scriptable scope, Object arg1, Object arg2) {
        super(scope, ScriptUtils.getClassOrObjectProto(scope, CLASSNAME));
        this.init(arg1, arg2);
    }

    @JSConstructor
    public void init(Object arg1, Object arg2) {
        this.setStream(arg1);
        this.setStream(arg2);
    }

    private void setStream(Object arg) {
        if (arg instanceof Wrapper) {
            arg = ((Wrapper)arg).unwrap();
        }
        if (arg instanceof InputStream) {
            this.input = (InputStream)arg;
        } else if (arg instanceof OutputStream) {
            this.output = (OutputStream)arg;
        } else if (arg != Undefined.instance && arg != null) {
            throw ScriptRuntime.constructError((String)"Error", (String)("Unsupported argument: " + arg));
        }
    }

    @JSFunction
    public boolean readable() {
        return this.input != null;
    }

    @JSFunction
    public boolean writable() {
        return this.output != null;
    }

    @JSFunction
    public boolean seekable() {
        return false;
    }

    @JSFunction
    public Object read(Object limit) {
        if (this.input == null) {
            throw ScriptRuntime.constructError((String)"Error", (String)"no input stream");
        }
        int max = limit == Undefined.instance ? -1 : ScriptRuntime.toInt32((Object)limit);
        Scriptable scope = ScriptableObject.getTopLevelScope((Scriptable)this);
        if (max > -1) {
            try {
                byte[] bytes = new byte[max];
                int read = this.input.read(bytes);
                return read > -1 ? new Binary(scope, Binary.Type.ByteString, bytes, 0, read) : new Binary(scope, Binary.Type.ByteString, 0);
            }
            catch (IOException iox) {
                throw new WrappedException((Throwable)iox);
            }
        }
        byte[] buffer = new byte[8192];
        int count = 0;
        try {
            int read;
            while ((read = this.input.read(buffer, count, buffer.length - count)) > -1) {
                if ((count += read) != buffer.length) continue;
                byte[] b = new byte[buffer.length * 2];
                System.arraycopy(buffer, 0, b, 0, count);
                buffer = b;
            }
            return count > -1 ? new Binary(scope, Binary.Type.ByteString, buffer, 0, count) : new Binary(scope, Binary.Type.ByteString, 0);
        }
        catch (IOException iox) {
            throw ScriptRuntime.constructError((String)"Error", (String)("Error reading from input stream: " + iox));
        }
    }

    @JSFunction
    public int readInto(Binary bytes, Object start, Object end) {
        if (this.input == null) {
            throw ScriptRuntime.constructError((String)"Error", (String)"no input stream");
        }
        if (bytes == Undefined.instance || bytes == null) {
            throw ScriptRuntime.constructError((String)"Error", (String)"readInto called without Binary argument");
        }
        if (bytes.getType() != Binary.Type.ByteArray) {
            throw ScriptRuntime.constructError((String)"Error", (String)"argument to readInto must be ByteArray");
        }
        int from = ScriptUtils.toInt(start, 0);
        int to = ScriptUtils.toInt(end, bytes.getLength());
        try {
            byte[] b = bytes.getBytes();
            return this.input.read(b, from, to - from);
        }
        catch (IOException iox) {
            throw new WrappedException((Throwable)iox);
        }
    }

    @JSFunction
    public void write(Object arg, Object start, Object end) {
        byte[] bytes;
        if (arg instanceof Wrapper) {
            arg = ((Wrapper)arg).unwrap();
        }
        if (arg instanceof Binary) {
            bytes = ((Binary)((Object)arg)).getBytes();
        } else if (arg instanceof byte[]) {
            bytes = (byte[])arg;
        } else if (arg instanceof String) {
            System.err.println("Warning: binary write called with string argument. Using default encoding.");
            bytes = ((String)arg).getBytes();
        } else {
            throw Context.reportRuntimeError((String)("write called with illegal argument: " + arg));
        }
        if (this.output == null) {
            throw ScriptRuntime.constructError((String)"Error", (String)"no output stream");
        }
        int from = start == Undefined.instance ? 0 : ScriptRuntime.toInt32((Object)start);
        int to = end == Undefined.instance ? bytes.length : ScriptRuntime.toInt32((Object)end);
        try {
            this.output.write(bytes, from, to - from);
        }
        catch (IOException iox) {
            throw Context.throwAsScriptRuntimeEx((Throwable)iox);
        }
    }

    @JSFunction
    public void flush() {
        if (this.output == null) {
            throw ScriptRuntime.constructError((String)"Error", (String)"no output stream");
        }
        try {
            this.output.flush();
        }
        catch (IOException iox) {
            throw new WrappedException((Throwable)iox);
        }
    }

    @JSFunction
    public int skip(int num) {
        try {
            if (this.input != null) {
                return (int)this.input.skip(num);
            }
            throw Context.reportRuntimeError((String)"skip() invoked on non-readable Stream");
        }
        catch (IOException iox) {
            throw new WrappedException((Throwable)iox);
        }
    }

    @JSFunction
    public void close() {
        try {
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            this.closed = true;
        }
        catch (IOException iox) {
            throw new WrappedException((Throwable)iox);
        }
    }

    @JSFunction
    public boolean closed() {
        return this.closed;
    }

    @JSFunction(value="unwrap")
    public Object jsunwrap() {
        return new NativeJavaObject(this.getParentScope(), this.unwrap(), null);
    }

    @JSGetter
    public Object getInputStream() {
        return this.input == null ? null : new NativeJavaObject(this.getParentScope(), (Object)this.input, null);
    }

    @JSGetter
    public Object getOutputStream() {
        return this.output == null ? null : new NativeJavaObject(this.getParentScope(), (Object)this.output, null);
    }

    public Object unwrap() {
        return this.input != null ? this.input : this.output;
    }

    public String getClassName() {
        return CLASSNAME;
    }
}

