/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.wrappers;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSStaticFunction;
import org.ringojs.util.ScriptUtils;

public class Storable
extends ScriptableObject {
    private Scriptable store;
    private String type;
    private boolean isPrototype;
    private Scriptable properties;
    private Object key;
    private Object entity;

    public Storable() {
        this.isPrototype = true;
    }

    private Storable(Scriptable store, String type) {
        this.store = store;
        this.type = type;
        this.isPrototype = true;
    }

    private Storable(Storable prototype) {
        this.store = prototype.store;
        this.type = prototype.type;
        this.isPrototype = false;
    }

    @JSStaticFunction
    public static Scriptable defineEntity(Scriptable store, String type, Object mapping) throws NoSuchMethodException {
        int attr = 7;
        Scriptable scope = ScriptRuntime.getTopCallScope((Context)Context.getCurrentContext());
        Storable prototype = new Storable(store, type);
        prototype.setParentScope(scope);
        prototype.setPrototype(ScriptableObject.getClassPrototype((Scriptable)scope, (String)"Storable"));
        FactoryFunction ctor = new FactoryFunction(prototype, scope, FactoryType.CONSTRUCTOR);
        ctor.setImmunePrototypeProperty((Object)prototype);
        Storable.defineProperty((Scriptable)prototype, (String)"constructor", (Object)((Object)ctor), (int)attr);
        FactoryFunction factory = new FactoryFunction(prototype, scope, FactoryType.FACTORY);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"createInstance", (Object)((Object)factory), (int)attr);
        if (mapping != Undefined.instance) {
            ctor.defineProperty("mapping", mapping, attr);
            factory.defineProperty("mapping", mapping, attr);
        }
        return ctor;
    }

    public String getClassName() {
        return "Storable";
    }

    protected Object equivalentValues(Object value) {
        if (this == value) {
            return Boolean.TRUE;
        }
        if (value instanceof Storable && this.isPersistent()) {
            Storable s = (Storable)((Object)value);
            return this.invokeStoreMethod("equalKeys", this.key, s.key);
        }
        return NOT_FOUND;
    }

    @JSFunction
    public void save(Object transaction) {
        if (!this.isPrototype) {
            if (this.entity == null) {
                this.entity = this.invokeStoreMethod("getEntity", this.type, this.properties != null ? this.properties : this.key);
            }
            if (transaction == Undefined.instance) {
                this.invokeStoreMethod("save", this.properties, this.entity);
            } else {
                this.invokeStoreMethod("save", this.properties, this.entity, transaction);
            }
        }
    }

    @JSFunction(value="remove")
    public void jsremove(Object transaction) {
        if (!this.isPrototype && this.isPersistent()) {
            if (this.key == null) {
                this.key = this.invokeStoreMethod("getKey", this.type, this.entity);
            }
            if (transaction == Undefined.instance) {
                this.invokeStoreMethod("remove", this.key);
            } else {
                this.invokeStoreMethod("remove", this.key, transaction);
            }
        }
    }

    @JSGetter(value="_key")
    public Object getKey() {
        if (!this.isPrototype && this.isPersistent()) {
            if (this.key == null) {
                this.key = this.invokeStoreMethod("getKey", this.type, this.entity);
            }
            return this.key;
        }
        return Undefined.instance;
    }

    @JSGetter(value="_id")
    public Object getId() {
        Object k = this.getKey();
        if (k != Undefined.instance) {
            return this.invokeStoreMethod("getId", k);
        }
        return Undefined.instance;
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, (Scriptable)this)) {
            return true;
        }
        if (this.isPrototype) {
            return super.has(name, start);
        }
        if (this.properties == null && this.isPersistent()) {
            this.properties = this.loadProperties();
        }
        return this.properties != null && this.properties.has(name, this.properties);
    }

    public Object get(String name, Scriptable start) {
        if (this.isPrototype || super.has(name, (Scriptable)this)) {
            return super.get(name, start);
        }
        if (this.properties == null && this.isPersistent()) {
            this.properties = this.loadProperties();
        }
        return this.properties == null ? Scriptable.NOT_FOUND : this.properties.get(name, this.properties);
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.isPrototype || super.has(name, (Scriptable)this)) {
            super.put(name, start, value);
        } else {
            if (this.properties == null) {
                this.properties = this.loadProperties();
            }
            this.properties.put(name, this.properties, value);
        }
    }

    public void delete(String name) {
        if (this.isPrototype || super.has(name, (Scriptable)this)) {
            super.delete(name);
        } else {
            if (this.properties == null) {
                this.properties = this.loadProperties();
            }
            this.properties.put(name, this.properties, null);
        }
    }

    public Object[] getIds() {
        if (this.isPrototype) {
            return super.getIds();
        }
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties.getIds();
    }

    public String getType() {
        return this.type;
    }

    private boolean isPersistent() {
        return this.key != null || this.entity != null;
    }

    private Scriptable loadProperties() {
        if (this.entity == null) {
            this.entity = this.invokeStoreMethod("getEntity", this.type, this.key);
        }
        return (Scriptable)this.invokeStoreMethod("getProperties", this.store, this.entity);
    }

    private Object invokeStoreMethod(String method, Object ... args) {
        Object value = ScriptableObject.getProperty((Scriptable)this.store, (String)method);
        if (value instanceof Callable) {
            return ((Callable)value).call(Context.getCurrentContext(), this.getParentScope(), this.store, args);
        }
        throw new RuntimeException("Store does not implement '" + method + "' method");
    }

    static class FactoryFunction
    extends BaseFunction {
        Storable prototype;
        FactoryType factoryType;

        FactoryFunction(Storable prototype, Scriptable scope, FactoryType factoryType) {
            this.prototype = prototype;
            this.factoryType = factoryType;
            ScriptRuntime.setFunctionProtoAndParent((BaseFunction)this, (Scriptable)scope);
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            Storable storable = new Storable(this.prototype);
            switch (this.factoryType) {
                case CONSTRUCTOR: {
                    ScriptUtils.checkArguments(args, 0, 1);
                    ScriptableObject properties = ScriptUtils.getScriptableArgument(args, 0, true);
                    if (properties == null) {
                        properties = cx.newObject(scope);
                    }
                    storable.properties = (Scriptable)properties;
                    break;
                }
                case FACTORY: {
                    ScriptUtils.checkArguments(args, 1, 2);
                    storable.key = ScriptUtils.getObjectArgument(args, 0, false);
                    storable.entity = ScriptUtils.getObjectArgument(args, 1, true);
                }
            }
            storable.setParentScope(scope);
            storable.setPrototype((Scriptable)this.prototype);
            return storable;
        }

        public int getArity() {
            return this.factoryType == FactoryType.CONSTRUCTOR ? 1 : 2;
        }

        public String getFunctionName() {
            return this.prototype.getType();
        }

        public int getLength() {
            return this.getArity();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FactoryType {
        CONSTRUCTOR,
        FACTORY;

    }
}

