/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.wrappers;

import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptableWrapper
extends ScriptableObject {
    private Scriptable wrapped;
    private Scriptable properties;

    public ScriptableWrapper() {
    }

    public ScriptableWrapper(Scriptable wrapped, Scriptable properties) {
        this.wrapped = wrapped;
        this.properties = properties;
    }

    public String getClassName() {
        return "ScriptableWrapper";
    }

    public Object get(String name, Scriptable start) {
        Object value;
        if (this.wrapped == null) {
            return super.get(name, start);
        }
        if (name.startsWith("super$")) {
            return this.wrapped.get(name.substring(6), this.wrapped);
        }
        if (this.properties != null && (value = this.properties.get(name, this.properties)) != NOT_FOUND) {
            return value;
        }
        return this.wrapped.get(name, this.wrapped);
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.wrapped == null) {
            super.put(name, (Scriptable)this, value);
        } else if (this.properties.has(name, start)) {
            this.properties.put(name, this.properties, value);
        } else {
            this.wrapped.put(name, this.wrapped, value);
        }
    }

    public void delete(String name) {
        if (this.wrapped == null) {
            super.delete(name);
        } else if (this.properties.has(name, this.properties)) {
            this.properties.delete(name);
        } else {
            this.wrapped.delete(name);
        }
    }

    public boolean has(String name, Scriptable start) {
        if (this.wrapped == null) {
            return super.has(name, (Scriptable)this);
        }
        return this.wrapped.has(name, this.wrapped) || this.properties.has(name, this.properties);
    }
}

