/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.wrappers;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.ringojs.util.ScriptUtils;

public class ScriptableMap
extends NativeJavaObject {
    boolean reflect;
    Map map;
    static final String CLASSNAME = "ScriptableMap";

    public static void init(Scriptable scope) throws NoSuchMethodException {
        BaseFunction ctor = new BaseFunction(scope, ScriptableObject.getFunctionPrototype((Scriptable)scope)){

            public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
                boolean reflect = false;
                if (args.length > 2) {
                    throw new EvaluatorException("ScriptableMap() called with too many arguments");
                }
                if (args.length == 2) {
                    reflect = ScriptRuntime.toBoolean((Object)args[1]);
                }
                return new ScriptableMap(scope, args.length == 0 ? null : args[0], reflect);
            }

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return this.construct(cx, scope, args);
            }
        };
        ScriptableObject.defineProperty((Scriptable)scope, (String)CLASSNAME, (Object)ctor, (int)3);
    }

    private ScriptableMap(Scriptable scope, Object obj, boolean reflect) {
        this.parent = scope;
        this.reflect = reflect;
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (obj instanceof Map) {
            this.map = (Map)obj;
        } else if (obj == null || obj == Undefined.instance) {
            this.map = new HashMap();
        } else if (obj instanceof Scriptable) {
            Object[] ids;
            this.map = new HashMap();
            Scriptable s = (Scriptable)obj;
            for (Object id : ids = s.getIds()) {
                if (id instanceof String) {
                    this.map.put(id, s.get((String)id, s));
                    continue;
                }
                if (!(id instanceof Number)) continue;
                this.map.put(id, s.get(((Number)id).intValue(), s));
            }
        } else {
            throw new EvaluatorException("Invalid argument to ScriptableMap(): " + obj);
        }
        this.javaObject = this.map;
        this.staticType = this.map.getClass();
        this.initMembers();
        this.initPrototype(scope);
    }

    public ScriptableMap(Scriptable scope, Map map) {
        super(scope, (Object)map, map.getClass());
        this.map = map;
        this.initPrototype(scope);
    }

    protected void initPrototype(Scriptable scope) {
        Scriptable objectProto = ScriptableObject.getClassPrototype((Scriptable)scope, (String)"Object");
        if (objectProto != null) {
            this.setPrototype(objectProto);
        }
    }

    public Object get(String name, Scriptable start) {
        if (this.map == null || this.reflect && super.has(name, start)) {
            return super.get(name, start);
        }
        return this.getInternal(name);
    }

    public Object get(int index, Scriptable start) {
        if (this.map == null) {
            return super.get(index, start);
        }
        return this.getInternal(new Integer(index));
    }

    private Object getInternal(Object key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Scriptable.NOT_FOUND;
        }
        return ScriptUtils.javaToJS(value, this.getParentScope());
    }

    public boolean has(String name, Scriptable start) {
        if (this.map == null || this.reflect && super.has(name, start)) {
            return super.has(name, start);
        }
        return this.map.containsKey(name);
    }

    public boolean has(int index, Scriptable start) {
        if (this.map == null) {
            return super.has(index, start);
        }
        return this.map.containsKey(new Integer(index));
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.map == null || this.reflect && super.has(name, start)) {
            super.put(name, start, value);
        } else {
            this.putInternal(name, value);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        if (this.map == null) {
            super.put(index, start, value);
        } else {
            this.putInternal(new Integer(index), value);
        }
    }

    private void putInternal(Object key, Object value) {
        try {
            this.map.put(key, ScriptUtils.jsToJava(value));
        }
        catch (RuntimeException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    public void delete(String name) {
        if (this.map != null) {
            try {
                this.map.remove(name);
            }
            catch (RuntimeException e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        } else {
            super.delete(name);
        }
    }

    public void delete(int index) {
        if (this.map != null) {
            try {
                this.map.remove(new Integer(index));
            }
            catch (RuntimeException e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        } else {
            super.delete(index);
        }
    }

    public Object[] getIds() {
        if (this.map == null) {
            return super.getIds();
        }
        return this.map.keySet().toArray();
    }

    public String toString() {
        if (this.map == null) {
            return super.toString();
        }
        return this.map.toString();
    }

    public Object getDefaultValue(Class typeHint) {
        return this.toString();
    }

    public Object unwrap() {
        return this.map;
    }

    public Map getMap() {
        return this.map;
    }

    public String getClassName() {
        return CLASSNAME;
    }
}

