/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.ringojs.util.ScriptUtils;

public class ScriptableList
extends NativeJavaObject {
    List<Object> list;
    static final String CLASSNAME = "ScriptableList";

    public static void init(Scriptable scope) throws NoSuchMethodException {
        BaseFunction ctor = new BaseFunction(scope, ScriptableObject.getFunctionPrototype((Scriptable)scope)){

            public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
                if (args.length > 1) {
                    throw new EvaluatorException("ScriptableList() requires a java.util.List argument");
                }
                return new ScriptableList(scope, args.length == 0 ? null : args[0]);
            }

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return this.construct(cx, scope, args);
            }
        };
        ScriptableObject.defineProperty((Scriptable)scope, (String)CLASSNAME, (Object)ctor, (int)3);
    }

    private ScriptableList(Scriptable scope, Object obj) {
        this.parent = scope;
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (obj instanceof List) {
            this.list = (List)obj;
            this.javaObject = this.list;
        } else if (obj instanceof Collection) {
            this.list = new ArrayList<Object>((Collection)obj);
            this.javaObject = this.list;
        } else if (obj instanceof Map) {
            this.list = new ArrayList(((Map)obj).values());
            this.javaObject = this.list;
        } else if (obj == null || obj == Undefined.instance) {
            this.list = new ArrayList<Object>();
            this.javaObject = this.list;
        } else {
            throw new EvaluatorException("Invalid argument to ScriptableList(): " + obj);
        }
        this.staticType = this.list.getClass();
        this.initMembers();
        this.initPrototype(scope);
    }

    public ScriptableList(Scriptable scope, List list) {
        super(scope, (Object)list, list.getClass());
        this.list = list;
        this.initPrototype(scope);
    }

    protected void initPrototype(Scriptable scope) {
        Scriptable arrayProto = ScriptableObject.getClassPrototype((Scriptable)scope, (String)"Array");
        if (arrayProto != null) {
            this.setPrototype(arrayProto);
        }
    }

    public void delete(int index) {
        if (this.list != null) {
            try {
                this.list.remove(index);
            }
            catch (RuntimeException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        } else {
            super.delete(index);
        }
    }

    public Object get(int index, Scriptable start) {
        if (this.list == null) {
            return super.get(index, start);
        }
        try {
            if (index < 0 || index >= this.list.size()) {
                return Undefined.instance;
            }
            return ScriptUtils.javaToJS(this.list.get(index), this.getParentScope());
        }
        catch (RuntimeException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    public boolean has(int index, Scriptable start) {
        if (this.list == null) {
            return super.has(index, start);
        }
        return index >= 0 && index < this.list.size();
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.list != null && "length".equals(name)) {
            double d = ScriptRuntime.toNumber((Object)value);
            long longVal = ScriptRuntime.toUint32((double)d);
            if ((double)longVal != d) {
                String msg = ScriptRuntime.getMessage0((String)"msg.arraylength.bad");
                throw ScriptRuntime.constructError((String)"RangeError", (String)msg);
            }
            int size = this.list.size();
            if (longVal > (long)size) {
                int i = size;
                while ((long)i < longVal) {
                    this.list.add(null);
                    ++i;
                }
            } else if (longVal < (long)size) {
                int i = size - 1;
                while ((long)i >= longVal) {
                    this.list.remove(i);
                    --i;
                }
            }
        } else {
            super.put(name, start, value);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        block5: {
            if (this.list != null) {
                try {
                    if (index == this.list.size()) {
                        this.list.add(ScriptUtils.jsToJava(value));
                        break block5;
                    }
                    this.list.set(index, ScriptUtils.jsToJava(value));
                }
                catch (RuntimeException e) {
                    Context.throwAsScriptRuntimeEx((Throwable)e);
                }
            } else {
                super.put(index, start, value);
            }
        }
    }

    public Object get(String name, Scriptable start) {
        if ("length".equals(name) && this.list != null) {
            return new Integer(this.list.size());
        }
        return super.get(name, start);
    }

    public Object[] getIds() {
        if (this.list == null) {
            return super.getIds();
        }
        int size = this.list.size();
        Object[] ids = new Object[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = new Integer(i);
        }
        return ids;
    }

    public String toString() {
        if (this.list == null) {
            return super.toString();
        }
        return this.list.toString();
    }

    public Object getDefaultValue(Class typeHint) {
        return this.toString();
    }

    public Object unwrap() {
        return this.list;
    }

    public List getList() {
        return this.list;
    }

    public String getClassName() {
        return CLASSNAME;
    }
}

