/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.wrappers;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.ringojs.engine.Callback;
import org.ringojs.engine.RhinoEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAdapter
extends ScriptableObject {
    private RhinoEngine engine;
    private Map<String, List<Callback>> callbacks = new HashMap<String, List<Callback>>();
    private Object impl;
    static Map<AdapterKey, WeakReference<Class<?>>> adapterCache = new HashMap();
    static AtomicInteger serial = new AtomicInteger();

    public String getClassName() {
        return "EventAdapter";
    }

    public EventAdapter() {
        this.engine = null;
    }

    public EventAdapter(RhinoEngine engine) {
        this.engine = engine;
    }

    @JSConstructor
    public static Object jsConstructor(Context cx, Object[] args, Function function, boolean inNewExpr) {
        Object[] classes;
        if (args.length == 0) {
            throw ScriptRuntime.typeError((String)"EventAdapter requires at least one argument");
        }
        if (!(args[0] instanceof List)) {
            throw ScriptRuntime.typeError((String)"First argument must be an Array or List");
        }
        for (Object aClass : classes = ((List)args[0]).toArray()) {
            if (aClass instanceof Class) continue;
            throw ScriptRuntime.typeError((String)("Not a Java class: " + ScriptRuntime.toString((Object)aClass)));
        }
        Map overrides = args.length > 1 && args[1] instanceof Map ? (Map)args[1] : null;
        try {
            Class<?> adapterClass = EventAdapter.getAdapterClass(classes, overrides);
            Scriptable scope = EventAdapter.getTopLevelScope((Scriptable)function);
            RhinoEngine engine = RhinoEngine.getEngine(scope);
            Constructor<?> cnst = adapterClass.getConstructor(EventAdapter.class);
            EventAdapter adapter = new EventAdapter(engine);
            adapter.impl = cnst.newInstance(new Object[]{adapter});
            return adapter;
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx((Throwable)ex);
        }
    }

    @JSGetter
    public Object getImpl() {
        return this.impl;
    }

    @JSFunction
    public Object addListener(String type, Object function) {
        this.addListener(type, false, function);
        return this;
    }

    @JSFunction
    public Object addSyncListener(String type, Object function) {
        this.addListener(type, true, function);
        return this;
    }

    private void addListener(String type, boolean sync, Object function) {
        List<Callback> list;
        if (!(function instanceof Scriptable)) {
            Context.reportError((String)"Event listener must be an object or function");
        }
        if ((list = this.callbacks.get(type)) == null) {
            list = new LinkedList<Callback>();
            this.callbacks.put(type, list);
        }
        list.add(new Callback((Scriptable)function, this.engine, sync));
    }

    @JSFunction
    public Object removeListener(String type, Object callback) {
        List<Callback> list = this.callbacks.get(type);
        if (list != null && callback instanceof Scriptable) {
            Scriptable s = (Scriptable)callback;
            Iterator<Callback> it = list.iterator();
            while (it.hasNext()) {
                if (!it.next().equalsCallback(s)) continue;
                it.remove();
                break;
            }
        }
        return this;
    }

    @JSFunction
    public Object removeAllListeners(String type) {
        this.callbacks.remove(type);
        return this;
    }

    @JSFunction
    public static boolean emit(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (!(thisObj instanceof EventAdapter)) {
            throw ScriptRuntime.typeError((String)("emit() called on incompatible object: " + ScriptRuntime.toString((Object)thisObj)));
        }
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            throw ScriptRuntime.typeError((String)"emit() requires event type as first argument");
        }
        String type = ScriptRuntime.toString((Object)args[0]);
        int length = args.length - 1;
        Object[] fargs = new Object[length];
        System.arraycopy(args, 1, fargs, 0, length);
        EventAdapter self = (EventAdapter)thisObj;
        return self.emit(type, fargs);
    }

    public boolean emit(String type, Object ... args) {
        List<Callback> list = this.callbacks.get(type);
        if (list != null) {
            for (Callback callback : list) {
                callback.invoke(args);
            }
            return !list.isEmpty();
        }
        return false;
    }

    public static Class<?> getAdapterClass(Object[] classes, Map<?, ?> overrides) {
        Class<?> adapterClass;
        AdapterKey key = new AdapterKey(classes, overrides);
        WeakReference<Class<?>> cachedClass = adapterCache.get(key);
        Class<?> clazz = adapterClass = cachedClass == null ? null : (Class<?>)cachedClass.get();
        if (adapterClass == null) {
            String className = "org.ringojs.adapter.EventAdapter" + serial.incrementAndGet();
            byte[] code = EventAdapter.getAdapterClass(className, classes, overrides);
            adapterClass = EventAdapter.loadAdapterClass(className, code);
            adapterCache.put(key, new WeakReference(adapterClass));
        }
        return adapterClass;
    }

    private static byte[] getAdapterClass(String className, Object[] classes, Map<?, ?> overrides) {
        HashSet methods = new HashSet();
        Class clazz = (Class)classes[0];
        boolean isInterface = clazz.isInterface();
        String superName = isInterface ? Object.class.getName() : clazz.getName();
        String adapterSignature = EventAdapter.classToSignature(EventAdapter.class);
        ClassFileWriter cfw = new ClassFileWriter(className, superName, "<EventAdapter>");
        for (Object c : classes) {
            clazz = (Class)c;
            if (clazz.isInterface()) {
                cfw.addInterface(clazz.getName());
            }
            Collections.addAll(methods, clazz.getMethods());
        }
        cfw.addField("events", adapterSignature, (short)18);
        cfw.startMethod("<init>", "(" + adapterSignature + ")V", (short)1);
        cfw.addLoadThis();
        cfw.addInvoke(183, superName, "<init>", "()V");
        cfw.addLoadThis();
        cfw.add(43);
        cfw.add(181, cfw.getClassName(), "events", adapterSignature);
        cfw.add(177);
        cfw.stopMethod((short)2);
        for (Method method : methods) {
            String methodName = method.getName();
            String eventName = overrides == null ? EventAdapter.toEventName(methodName) : EventAdapter.toStringOrNull(overrides.get(methodName));
            int mod = method.getModifiers();
            if (!Modifier.isAbstract(mod) && (eventName == null || Modifier.isFinal(mod))) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            int paramLength = paramTypes.length;
            int localsLength = paramLength + 1;
            for (Class<?> c : paramTypes) {
                if (c != Double.TYPE && c != Long.TYPE) continue;
                ++localsLength;
            }
            Class<?> returnType = method.getReturnType();
            cfw.startMethod(methodName, EventAdapter.getSignature(paramTypes, returnType), (short)1);
            cfw.addLoadThis();
            cfw.add(180, cfw.getClassName(), "events", adapterSignature);
            cfw.addLoadConstant(eventName);
            cfw.addLoadConstant(paramLength);
            cfw.add(189, "java/lang/Object");
            for (int i = 0; i < paramLength; ++i) {
                cfw.add(89);
                cfw.addLoadConstant(i);
                Class<?> param = paramTypes[i];
                if (param == Integer.TYPE || param == Byte.TYPE || param == Character.TYPE || param == Short.TYPE) {
                    cfw.addILoad(i + 1);
                    cfw.addInvoke(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                } else if (param == Boolean.TYPE) {
                    cfw.addILoad(i + 1);
                    cfw.addInvoke(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                } else if (param == Double.TYPE) {
                    cfw.addDLoad(i + 1);
                    cfw.addInvoke(184, "java/lang/Double", "valueOf", "(I)Ljava/lang/Double;");
                } else if (param == Float.TYPE) {
                    cfw.addFLoad(i + 1);
                    cfw.addInvoke(184, "java/lang/Float", "valueOf", "(I)Ljava/lang/Float;");
                } else if (param == Long.TYPE) {
                    cfw.addLLoad(i + 1);
                    cfw.addInvoke(184, "java/lang/Long", "valueOf", "(I)Ljava/lang/Long;");
                } else {
                    cfw.addALoad(i + 1);
                }
                cfw.add(83);
            }
            cfw.addInvoke(182, EventAdapter.class.getName(), "emit", "(Ljava/lang/String;[Ljava/lang/Object;)Z");
            cfw.add(87);
            if (returnType == Void.TYPE) {
                cfw.add(177);
            } else if (returnType == Integer.TYPE || returnType == Byte.TYPE || returnType == Character.TYPE || returnType == Short.TYPE) {
                cfw.add(3);
                cfw.add(172);
            } else if (returnType == Boolean.TYPE) {
                cfw.add(4);
                cfw.add(172);
            } else if (returnType == Double.TYPE) {
                cfw.add(14);
                cfw.add(175);
            } else if (returnType == Float.TYPE) {
                cfw.add(11);
                cfw.add(174);
            } else if (returnType == Long.TYPE) {
                cfw.add(9);
                cfw.add(173);
            } else {
                cfw.add(1);
                cfw.add(176);
            }
            cfw.stopMethod((short)localsLength);
        }
        return cfw.toByteArray();
    }

    private static Class<?> loadAdapterClass(String className, byte[] classBytes) {
        Object staticDomain;
        Class domainClass = SecurityController.getStaticSecurityDomainClass();
        if (domainClass == CodeSource.class || domainClass == ProtectionDomain.class) {
            ProtectionDomain protectionDomain = SecurityUtilities.getScriptProtectionDomain();
            if (protectionDomain == null) {
                protectionDomain = EventAdapter.class.getProtectionDomain();
            }
            staticDomain = domainClass == CodeSource.class ? (protectionDomain == null ? null : protectionDomain.getCodeSource()) : protectionDomain;
        } else {
            staticDomain = null;
        }
        GeneratedClassLoader loader = SecurityController.createLoader(null, staticDomain);
        Class result = loader.defineClass(className, classBytes);
        loader.linkClass(result);
        return result;
    }

    private static String toStringOrNull(Object name) {
        return name == null ? null : name.toString();
    }

    public static String toEventName(Object name) {
        String methodName = ScriptRuntime.toString((Object)name);
        int length = methodName.length();
        if (length > 2 && methodName.regionMatches(0, "on", 0, 2) && Character.isUpperCase(methodName.charAt(2))) {
            char[] chars = new char[length - 2];
            methodName.getChars(2, length, chars, 0);
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }
        return methodName;
    }

    public static String getSignature(Class<?>[] paramTypes, Class<?> returnType) {
        StringBuilder b = new StringBuilder("(");
        for (Class<?> param : paramTypes) {
            b.append(EventAdapter.classToSignature(param));
        }
        b.append(")");
        b.append(EventAdapter.classToSignature(returnType));
        return b.toString();
    }

    public static String classToSignature(Class<?> clazz) {
        if (clazz.isArray()) {
            return "[" + EventAdapter.classToSignature(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
        }
        return ClassFileWriter.classNameToSignature((String)clazz.getName());
    }

    static class AdapterKey {
        private final Object[] classes;
        private final Map overrides;

        AdapterKey(Object[] classes, Map overrides) {
            assert (classes != null);
            this.classes = classes;
            this.overrides = overrides;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AdapterKey)) {
                return false;
            }
            AdapterKey key = (AdapterKey)obj;
            if (!Arrays.equals(this.classes, key.classes)) {
                return false;
            }
            if (this.overrides != null) {
                if (key.overrides == null || this.overrides.size() != key.overrides.size()) {
                    return false;
                }
                Iterator e1 = this.overrides.entrySet().iterator();
                Iterator e2 = key.overrides.entrySet().iterator();
                while (e1.hasNext()) {
                    if (e1.next().equals(e2.next())) continue;
                    return false;
                }
            } else if (key.overrides != null) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int h = Arrays.hashCode(this.classes);
            if (this.overrides != null) {
                Set entries = this.overrides.entrySet();
                int j = 0;
                for (Map.Entry e : entries) {
                    j += e.hashCode();
                }
                h = 31 * h + j;
            }
            return h;
        }

        public String toString() {
            return "AdapterKey[" + Arrays.toString(this.classes) + "]";
        }
    }
}

