/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.wrappers;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.ringojs.util.ScriptUtils;

public class Binary
extends ScriptableObject
implements Wrapper {
    private byte[] bytes;
    private int length;
    private final Type type;

    public Binary() {
        this.type = Type.Binary;
    }

    public Binary(Type type) {
        this.type = type;
    }

    public Binary(Scriptable scope, Type type, int length) {
        super(scope, ScriptUtils.getClassOrObjectProto(scope, type.toString()));
        this.type = type;
        this.bytes = new byte[Math.max(length, 8)];
        this.length = length;
    }

    public Binary(Scriptable scope, Type type, byte[] bytes) {
        this(scope, type, bytes, 0, bytes.length);
    }

    public Binary(Scriptable scope, Type type, byte[] bytes, int offset, int length) {
        super(scope, ScriptUtils.getClassOrObjectProto(scope, type.toString()));
        this.bytes = new byte[length];
        this.length = length;
        this.type = type;
        System.arraycopy(bytes, offset, this.bytes, 0, length);
    }

    @JSConstructor
    public static Object construct(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ScriptUtils.checkArguments(args, 0, 2);
        Scriptable scope = ctorObj.getParentScope();
        Type type = Type.valueOf((String)ctorObj.get("name", (Scriptable)ctorObj));
        if (type == Type.Binary) {
            throw ScriptRuntime.constructError((String)"Error", (String)"cannot instantiate Binary base class");
        }
        if (args.length == 0) {
            return new Binary(scope, type, 0);
        }
        Object arg = args[0];
        if (arg instanceof Wrapper) {
            arg = ((Wrapper)arg).unwrap();
        }
        if (args.length == 2) {
            if (!(arg instanceof String)) {
                throw ScriptRuntime.constructError((String)"Error", (String)"Expected string as first argument");
            }
            if (!(args[1] instanceof String)) {
                throw ScriptRuntime.constructError((String)"Error", (String)"Expected string as second argument");
            }
            try {
                return new Binary(scope, type, ((String)arg).getBytes((String)args[1]));
            }
            catch (UnsupportedEncodingException uee) {
                throw ScriptRuntime.constructError((String)"Error", (String)("Unsupported encoding: " + args[1]));
            }
        }
        if (arg instanceof Number && type == Type.ByteArray) {
            return new Binary(scope, type, ((Number)arg).intValue());
        }
        if (ScriptRuntime.isArrayObject((Object)arg)) {
            Scriptable object = (Scriptable)arg;
            long longLength = ScriptRuntime.toUint32((Object)ScriptRuntime.getObjectProp((Scriptable)object, (String)"length", (Context)cx));
            if (longLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            int length = (int)longLength;
            Binary bytes = new Binary(scope, type, length);
            for (int i = 0; i < length; ++i) {
                Object value = ScriptableObject.getProperty((Scriptable)object, (int)i);
                bytes.putInternal(i, value);
            }
            return bytes;
        }
        if (arg instanceof byte[]) {
            return new Binary(scope, type, (byte[])arg);
        }
        if (arg instanceof Binary) {
            return new Binary(scope, type, ((Binary)((Object)arg)).getBytes());
        }
        if (arg == Undefined.instance) {
            return new Binary(scope, type, 0);
        }
        throw ScriptRuntime.constructError((String)"Error", (String)("Unsupported argument: " + arg));
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable prototype) throws NoSuchMethodException {
        Binary.initClass(scope, prototype, Type.ByteArray);
        Binary.initClass(scope, prototype, Type.ByteString);
    }

    private static void initClass(Scriptable scope, Scriptable parentProto, Type type) throws NoSuchMethodException {
        Binary prototype = new Binary(type);
        prototype.setPrototype(parentProto);
        Method ctorMember = Binary.class.getMethod("construct", Context.class, Object[].class, Function.class, Boolean.TYPE);
        FunctionObject constructor = new FunctionObject(type.toString(), (Member)ctorMember, scope);
        constructor.addAsConstructor(scope, (Scriptable)prototype);
        constructor.defineProperty("wrap", (Object)new Wrap(scope, (Scriptable)prototype, type), 7);
    }

    public Type getType() {
        return this.type;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || index >= this.length) {
            return Undefined.instance;
        }
        return 0xFF & this.bytes[index];
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.length;
    }

    public void put(int index, Scriptable start, Object value) {
        if (this.type != Type.ByteArray) {
            return;
        }
        this.putInternal(index, value);
    }

    private void putInternal(int index, Object value) {
        if (index < 0) {
            throw ScriptRuntime.constructError((String)"Error", (String)"Negative ByteArray index");
        }
        if (!(value instanceof Number)) {
            throw ScriptRuntime.constructError((String)"Error", (String)("Non-numeric ByteArray member: " + value));
        }
        if (index >= this.length) {
            this.setLength(index + 1);
        }
        int n = ((Number)value).intValue();
        this.bytes[index] = (byte)(0xFF & n);
    }

    @JSGetter
    public int getLength() {
        return this.length;
    }

    @JSSetter
    public synchronized void setLength(Object length) {
        int l = ScriptUtils.toInt(length, -1);
        if (l < 0) {
            throw ScriptRuntime.constructError((String)"Error", (String)"Inappropriate ByteArray length");
        }
        this.setLength(l);
    }

    protected synchronized void setLength(int newLength) {
        if (this.type != Type.ByteArray) {
            return;
        }
        if (newLength < this.length) {
            Arrays.fill(this.bytes, newLength, this.length, (byte)0);
        } else if (newLength > this.bytes.length) {
            int newSize = Math.max(newLength, this.bytes.length * 2);
            byte[] b = new byte[newSize];
            System.arraycopy(this.bytes, 0, b, 0, this.length);
            this.bytes = b;
        }
        this.length = newLength;
    }

    @JSFunction
    public Object get(Object index) {
        int i = ScriptUtils.toInt(index, -1);
        if (i < 0 || i >= this.length) {
            return Undefined.instance;
        }
        return 0xFF & this.bytes[i];
    }

    @JSFunction
    public Object charCodeAt(Object index) {
        return this.get(index);
    }

    @JSFunction
    public Object byteAt(Object index) {
        int i = ScriptUtils.toInt(index, -1);
        if (i < 0 || i >= this.length) {
            return new Binary(this.getParentScope(), this.type, 0);
        }
        return new Binary(this.getParentScope(), this.type, new byte[]{this.bytes[i]});
    }

    @JSFunction
    public Object charAt(Object index) {
        return this.byteAt(index);
    }

    @JSFunction
    public void set(Object index, int value) {
        if (this.type != Type.ByteArray) {
            return;
        }
        int i = ScriptUtils.toInt(index, -1);
        if (i > -1) {
            if (i >= this.length) {
                this.setLength(i + 1);
            }
            this.bytes[i] = (byte)(0xFF & value);
        }
    }

    @JSFunction
    public Object toByteArray(Object sourceCharset, Object targetCharset) throws UnsupportedEncodingException {
        return this.makeCopy(Type.ByteArray, sourceCharset, targetCharset);
    }

    @JSFunction
    public Object toByteString(Object sourceCharset, Object targetCharset) throws UnsupportedEncodingException {
        if (this.type == Type.ByteString && sourceCharset == Undefined.instance && targetCharset == Undefined.instance) {
            return this;
        }
        return this.makeCopy(Type.ByteString, sourceCharset, targetCharset);
    }

    private synchronized Binary makeCopy(Type targetType, Object sourceCharset, Object targetCharset) throws UnsupportedEncodingException {
        String source = this.toCharset(sourceCharset);
        String target = this.toCharset(targetCharset);
        if (source != null && target != null) {
            String str = new String(this.bytes, 0, this.length, source);
            return new Binary(this.getParentScope(), targetType, str.getBytes(target));
        }
        if (this.type == Type.ByteString && this.type == targetType) {
            return this;
        }
        return new Binary(this.getParentScope(), targetType, this.bytes, 0, this.length);
    }

    @JSFunction
    public void copy(int srcStartIndex, int srcEndIndex, Binary target, Object targetIndex) {
        if (target.type != Type.ByteArray) {
            throw ScriptRuntime.constructError((String)"Error", (String)"Target object is not writable");
        }
        if (srcStartIndex < 0 || srcStartIndex >= this.length) {
            throw ScriptRuntime.constructError((String)"Error", (String)("Invalid start index: " + srcStartIndex));
        }
        if (srcEndIndex < srcStartIndex || srcEndIndex > this.length) {
            throw ScriptRuntime.constructError((String)"Error", (String)("Invalid end index: " + srcEndIndex));
        }
        int targetIdx = ScriptUtils.toInt(targetIndex, 0);
        if (targetIdx < 0) {
            throw ScriptRuntime.constructError((String)"Error", (String)("Invalid target index: " + targetIndex));
        }
        int size = srcEndIndex - srcStartIndex;
        target.copyFrom(this.bytes, srcStartIndex, size, targetIdx);
    }

    private synchronized void copyFrom(byte[] source, int srcIndex, int length, int targetIndex) {
        this.ensureLength(targetIndex + length);
        System.arraycopy(source, srcIndex, this.bytes, targetIndex, length);
    }

    @JSFunction
    public synchronized Object toArray(Object charset) throws UnsupportedEncodingException {
        Object[] elements;
        String cs = this.toCharset(charset);
        if (cs != null) {
            String str = new String(this.bytes, 0, this.length, cs);
            elements = new Object[str.length()];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = (int)str.charAt(i);
            }
        } else {
            elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                elements[i] = 0xFF & this.bytes[i];
            }
        }
        return Context.getCurrentContext().newArray(this.getParentScope(), elements);
    }

    @JSFunction
    public String toString() {
        if (this.bytes != null) {
            return "[" + this.type.toString() + " " + this.length + "]";
        }
        return "[object " + this.type.toString() + "]";
    }

    @JSFunction
    public Object slice(Object begin, Object end) {
        int to;
        if (begin == Undefined.instance && end == Undefined.instance) {
            return new Binary(this.getParentScope(), this.type, this.bytes, 0, this.length);
        }
        int from = ScriptUtils.toInt(begin, 0);
        if (from < 0) {
            from += this.length;
        }
        from = Math.min(this.length, Math.max(0, from));
        int n = to = end == Undefined.instance ? this.length : ScriptUtils.toInt(end, from);
        if (to < 0) {
            to += this.length;
        }
        int len = Math.max(0, Math.min(this.length - from, to - from));
        return new Binary(this.getParentScope(), this.type, this.bytes, from, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public static Object concat(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Binary thisByteArray;
        int arglength = 0;
        ArrayList<byte[]> arglist = new ArrayList<byte[]>(args.length);
        for (Object arg : args) {
            if (arg instanceof Binary) {
                byte[] bytes = ((Binary)((Object)arg)).getBytes();
                arglength += bytes.length;
                arglist.add(bytes);
                continue;
            }
            if (ScriptRuntime.isArrayObject((Object)arg)) {
                Scriptable object = (Scriptable)arg;
                long longLength = ScriptRuntime.toUint32((Object)ScriptRuntime.getObjectProp((Scriptable)object, (String)"length", (Context)cx));
                if (longLength > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                int length = (int)longLength;
                byte[] bytes = new byte[length];
                for (int i = 0; i < length; ++i) {
                    Object value = ScriptableObject.getProperty((Scriptable)object, (int)i);
                    if (!(value instanceof Number)) {
                        throw ScriptRuntime.constructError((String)"Error", (String)("Non-numeric ByteArray member: " + value));
                    }
                    int n = ((Number)value).intValue();
                    bytes[i] = (byte)(0xFF & n);
                }
                arglength += bytes.length;
                arglist.add(bytes);
                continue;
            }
            throw ScriptRuntime.constructError((String)"Error", (String)("Unsupported argument: " + arg));
        }
        Binary binary = thisByteArray = (Binary)thisObj;
        synchronized (binary) {
            byte[] newBytes = new byte[thisByteArray.length + arglength];
            System.arraycopy(thisByteArray.bytes, 0, newBytes, 0, thisByteArray.length);
            int index = thisByteArray.length;
            for (byte[] b : arglist) {
                System.arraycopy(b, 0, newBytes, index, b.length);
                index += b.length;
            }
            return new Binary(thisObj.getParentScope(), thisByteArray.type, newBytes);
        }
    }

    @JSFunction
    public String decodeToString(Object charset) {
        String cs = this.toCharset(charset);
        try {
            return cs == null ? new String(this.bytes, 0, this.length) : new String(this.bytes, 0, this.length, cs);
        }
        catch (UnsupportedEncodingException uee) {
            throw ScriptRuntime.constructError((String)"Error", (String)("Unsupported encoding: " + charset));
        }
    }

    @JSFunction
    public int indexOf(Object arg, Object from, Object to) {
        byte[] b = this.getBytesArgument(arg);
        int start = Math.max(0, Math.min(this.length - 1, ScriptUtils.toInt(from, 0)));
        int end = Math.max(0, Math.min(this.length - b.length + 1, ScriptUtils.toInt(to, this.length)));
        block0: for (int i = start; i < end; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (this.bytes[i + j] != b[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    @JSFunction
    public int lastIndexOf(Object arg, Object from, Object to) {
        byte[] b = this.getBytesArgument(arg);
        int start = Math.max(0, Math.min(this.length - 1, ScriptUtils.toInt(from, 0)));
        int end = Math.max(0, Math.min(this.length - b.length + 1, ScriptUtils.toInt(to, this.length)));
        block0: for (int i = end - 1; i >= start; --i) {
            for (int j = 0; j < b.length; ++j) {
                if (this.bytes[i + j] != b[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    @JSFunction
    public synchronized Object split(Object delim, Object options) {
        byte[][] delimiters = this.getSplitDelimiters(delim);
        boolean includeDelimiter = false;
        int count = Integer.MAX_VALUE;
        if (options instanceof Scriptable) {
            Scriptable o = (Scriptable)options;
            Object include = ScriptableObject.getProperty((Scriptable)o, (String)"includeDelimiter");
            includeDelimiter = include != NOT_FOUND && ScriptRuntime.toBoolean((Object)include);
            Object max = ScriptableObject.getProperty((Scriptable)o, (String)"count");
            if (max != NOT_FOUND) {
                count = ScriptRuntime.toInt32((Object)max);
            }
        }
        ArrayList<Binary> list = new ArrayList<Binary>();
        Scriptable scope = this.getParentScope();
        int index = 0;
        int found = 0;
        block0: for (int i = 0; i < this.length && found < count - 1; ++i) {
            block1: for (byte[] delimiter : delimiters) {
                if (i + delimiter.length > this.length) continue;
                for (int j = 0; j < delimiter.length; ++j) {
                    if (this.bytes[i + j] != delimiter[j]) continue block1;
                }
                list.add(new Binary(scope, this.type, this.bytes, index, i - index));
                if (includeDelimiter) {
                    list.add(new Binary(scope, this.type, delimiter));
                }
                index = i + delimiter.length;
                i = index - 1;
                ++found;
                continue block0;
            }
        }
        if (index == 0) {
            list.add(this);
        } else {
            list.add(new Binary(scope, this.type, this.bytes, index, this.length - index));
        }
        return Context.getCurrentContext().newArray(scope, list.toArray());
    }

    protected static Binary wrap(Type type, byte[] bytes, Scriptable scope, Scriptable prototype) {
        Binary wrapper = new Binary(type);
        wrapper.bytes = bytes;
        wrapper.length = bytes.length;
        wrapper.setParentScope(scope);
        wrapper.setPrototype(prototype);
        return wrapper;
    }

    @JSFunction(value="unwrap")
    public Object jsunwrap() {
        return NativeJavaArray.wrap((Scriptable)this.getParentScope(), (Object)this.getBytes());
    }

    public Object unwrap() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        this.normalize();
        return this.bytes;
    }

    public String getClassName() {
        return this.type.toString();
    }

    protected synchronized void ensureLength(int minLength) {
        if (minLength > this.length) {
            this.setLength(minLength);
        }
    }

    private synchronized void normalize() {
        if (this.length != this.bytes.length) {
            byte[] b = new byte[this.length];
            System.arraycopy(this.bytes, 0, b, 0, this.length);
            this.bytes = b;
        }
    }

    private byte[] getBytesArgument(Object arg) {
        if (arg instanceof Number) {
            return new byte[]{(byte)(0xFF & ((Number)arg).intValue())};
        }
        if (arg instanceof Binary) {
            return ((Binary)((Object)arg)).getBytes();
        }
        throw new RuntimeException("unsupported delimiter: " + arg);
    }

    private byte[][] getSplitDelimiters(Object delim) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        Collection values = null;
        if (delim instanceof Collection) {
            values = (Collection)delim;
        } else if (delim instanceof Map && delim instanceof NativeArray) {
            values = ((Map)delim).values();
        }
        if (values != null) {
            for (Object value : values) {
                list.add(this.getBytesArgument(value));
            }
        } else {
            list.add(this.getBytesArgument(delim));
        }
        return (byte[][])list.toArray((T[])new byte[list.size()][]);
    }

    private String toCharset(Object charset) {
        if (charset == Undefined.instance || charset == null) {
            return null;
        }
        if (!(charset instanceof String)) {
            throw ScriptRuntime.constructError((String)"Error", (String)("Charset is not a string: " + charset));
        }
        return (String)charset;
    }

    static class Wrap
    extends BaseFunction {
        Type type;
        Scriptable prototype;

        Wrap(Scriptable scope, Scriptable prototype, Type type) {
            super(scope, ScriptableObject.getFunctionPrototype((Scriptable)scope));
            this.type = type;
            this.prototype = prototype;
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            Object arg = ScriptUtils.getObjectArgument(args, 0, false);
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (!(arg instanceof byte[])) {
                throw ScriptRuntime.constructError((String)"Error", (String)"wrap() requires an argument of type byte[]");
            }
            byte[] bytes = (byte[])arg;
            return Binary.wrap(this.type, bytes, Wrap.getTopLevelScope((Scriptable)scope), this.prototype);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        Binary,
        ByteArray,
        ByteString;

    }
}

