/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.util;

import java.nio.CharBuffer;
import java.util.StringTokenizer;

public class StringUtils {
    public static String[] split(String str) {
        return StringUtils.split(str, ", \t\n\r\f");
    }

    public static String[] split(String str, String delim) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, delim);
        String[] s = new String[st.countTokens()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = st.nextToken();
        }
        return s;
    }

    public static String[] splitLines(String str) {
        if (str == null) {
            return new String[0];
        }
        return str.split("\\r\\n|\\r|\\n");
    }

    public static String join(String[] strings, String separator) {
        StringBuffer buffer = new StringBuffer();
        int length = strings.length;
        for (int i = 0; i < length; ++i) {
            buffer.append(strings[i]);
            if (i >= length - 1) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String escapeHtml(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }

    public static Class[] toClassArray(String str, String delim) throws ClassNotFoundException {
        String[] s = StringUtils.split(str, delim);
        Class[] classes = new Class[s.length];
        for (int i = 0; i < s.length; ++i) {
            classes[i] = Class.forName(s[i]);
        }
        return classes;
    }

    public static boolean isZipOrJarFile(String str) {
        if (str == null) {
            throw new NullPointerException("str must not be null");
        }
        String lower = str.toLowerCase();
        return lower.endsWith(".zip") || lower.endsWith(".jar");
    }

    public static int searchNewline(CharBuffer buffer, int from) {
        int to = buffer.position();
        if (from >= to) {
            return -1;
        }
        char[] chars = buffer.array();
        for (int i = from; i < to; ++i) {
            if (chars[i] != '\n' && (chars[i] != '\r' || i >= to - 1)) continue;
            return i;
        }
        return -1;
    }
}

