/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.util;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.Wrapper;
import org.ringojs.wrappers.ScriptableList;
import org.ringojs.wrappers.ScriptableMap;

public class ScriptUtils {
    public static Object javaToJS(Object obj, Scriptable scope) {
        if (obj instanceof Scriptable) {
            if (obj instanceof ScriptableObject && ((Scriptable)obj).getParentScope() == null && ((Scriptable)obj).getPrototype() == null) {
                ScriptRuntime.setObjectProtoAndParent((ScriptableObject)((ScriptableObject)obj), (Scriptable)scope);
            }
            return obj;
        }
        if (obj instanceof List) {
            return new ScriptableList(scope, (List)obj);
        }
        if (obj instanceof Map) {
            return new ScriptableMap(scope, (Map)obj);
        }
        return Context.javaToJS((Object)obj, (Scriptable)scope);
    }

    public static Object jsToJava(Object obj) {
        while (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        return obj;
    }

    public static Scriptable getClassOrObjectProto(Scriptable scope, String className) {
        Scriptable proto = ScriptableObject.getClassPrototype((Scriptable)scope, (String)className);
        if (proto == null) {
            proto = ScriptableObject.getObjectPrototype((Scriptable)scope);
        }
        return proto;
    }

    public static void checkArguments(Object[] args, int min, int max) {
        if (min > -1 && args.length < min) {
            throw new IllegalArgumentException();
        }
        if (max > -1 && args.length > max) {
            throw new IllegalArgumentException();
        }
    }

    public static ScriptableObject getScriptableArgument(Object[] args, int pos, boolean allowNull) throws IllegalArgumentException {
        if (pos >= args.length || args[pos] == null || args[pos] == Undefined.instance) {
            if (allowNull) {
                return null;
            }
            throw ScriptRuntime.constructError((String)"Error", (String)("Argument " + (pos + 1) + " must not be null"));
        }
        if (args[pos] instanceof ScriptableObject) {
            return (ScriptableObject)args[pos];
        }
        throw ScriptRuntime.constructError((String)"Error", (String)("Can't convert to ScriptableObject: " + args[pos]));
    }

    public static String getStringArgument(Object[] args, int pos, boolean allowNull) {
        if (pos >= args.length || args[pos] == null || args[pos] == Undefined.instance) {
            if (allowNull) {
                return null;
            }
            throw ScriptRuntime.constructError((String)"Error", (String)("Argument " + (pos + 1) + " must not be null"));
        }
        return ScriptRuntime.toString((Object)args[pos].toString());
    }

    public static Map getMapArgument(Object[] args, int pos, boolean allowNull) throws IllegalArgumentException {
        if (pos >= args.length || args[pos] == null || args[pos] == Undefined.instance) {
            if (allowNull) {
                return null;
            }
            throw ScriptRuntime.constructError((String)"Error", (String)("Argument " + (pos + 1) + " must not be null"));
        }
        if (args[pos] instanceof Map) {
            return (Map)args[pos];
        }
        throw ScriptRuntime.constructError((String)"Error", (String)("Can't convert to java.util.Map: " + args[pos]));
    }

    public static Object getObjectArgument(Object[] args, int pos, boolean allowNull) {
        if (pos >= args.length || args[pos] == null || args[pos] == Undefined.instance) {
            if (allowNull) {
                return null;
            }
            throw ScriptRuntime.constructError((String)"Error", (String)("Argument " + (pos + 1) + " must not be null"));
        }
        return args[pos];
    }

    public static int toInt(Object obj, int defaultValue) {
        double d = ScriptRuntime.toNumber((Object)obj);
        if (d == ScriptRuntime.NaN || (double)((int)d) != d) {
            return defaultValue;
        }
        return (int)d;
    }

    public static void traceHelper(Function function, Object ... args) {
        Context cx = Context.getCurrentContext();
        Scriptable scope = ScriptableObject.getTopLevelScope((Scriptable)function);
        EcmaError error = ScriptRuntime.constructError((String)"Trace", (String)"");
        WrapFactory wrapFactory = cx.getWrapFactory();
        Scriptable thisObj = wrapFactory.wrapAsJavaObject(cx, scope, (Object)error, null);
        for (int i = 0; i < args.length; ++i) {
            args[i] = wrapFactory.wrap(cx, scope, args[i], null);
        }
        function.call(cx, scope, thisObj, args);
    }

    public static void assertHelper(Object condition, Object ... args) {
        if (ScriptRuntime.toBoolean((Object)condition)) {
            return;
        }
        String msg = "";
        if (args.length > 0) {
            msg = ScriptRuntime.toString((Object)args[0]);
            Pattern pattern = Pattern.compile("%[sdifo]");
            for (int i = 1; i < args.length; ++i) {
                Matcher matcher = pattern.matcher(msg);
                msg = matcher.find() ? matcher.replaceFirst(ScriptRuntime.toString((Object)args[i])) : msg + " " + ScriptRuntime.toString((Object)args[i]);
            }
        }
        throw ScriptRuntime.constructError((String)"AssertionError", (String)msg);
    }
}

