/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public abstract class DebuggerBase
implements Debugger {
    String debuggerScript;
    int debuggerScriptDepth = 0;
    Logger log = Logger.getLogger(DebuggerBase.class.getName());

    public abstract DebuggerBase createDebugger();

    public abstract Object createContextData();

    public abstract void handleCompilationDone(Context var1, DebuggableScript var2, String var3);

    public abstract DebugFrame getScriptFrame(Context var1, DebuggableScript var2);

    public void attach() {
        this.attach(this.createContextData());
    }

    public void setDebuggerScript(String path) {
        this.debuggerScript = path;
    }

    public void install() {
        ContextFactory factory = Context.getCurrentContext().getFactory();
        factory.addListener(new ContextFactory.Listener(){

            public void contextCreated(Context cx) {
                DebuggerBase debugger = DebuggerBase.this.createDebugger();
                if (debugger != null) {
                    debugger.attach(DebuggerBase.this.createContextData());
                }
            }

            public void contextReleased(Context cx) {
            }
        });
    }

    public void attach(Object contextData) {
        Context cx = Context.getCurrentContext();
        cx.setDebugger((Debugger)this, contextData);
        cx.setOptimizationLevel(-1);
        cx.setGeneratingDebug(true);
    }

    public void detach() {
        Context cx = Context.getCurrentContext();
        cx.setDebugger(null, null);
    }

    public Object getContextData() {
        return Context.getCurrentContext().getDebuggerContextData();
    }

    public synchronized void suspend() {
        try {
            this.wait();
        }
        catch (InterruptedException ir) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void resume() {
        this.notify();
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        String path = fnOrScript.getSourceName();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Getting Frame for " + path + ", debugger script depth is " + this.debuggerScriptDepth);
        }
        if (this.debuggerScriptDepth > 0 || path.equals(this.debuggerScript)) {
            return new DebuggerScriptFrame();
        }
        return this.getScriptFrame(cx, fnOrScript);
    }

    static String getScriptName(DebuggableScript script) {
        if (script.isFunction()) {
            return script.getSourceName() + ": " + script.getFunctionName();
        }
        return script.getSourceName();
    }

    class DebuggerScriptFrame
    implements DebugFrame {
        DebuggerScriptFrame() {
        }

        public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
            DebuggerBase.this.log.fine("Entering debugger script frame");
            ++DebuggerBase.this.debuggerScriptDepth;
        }

        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
            DebuggerBase.this.log.fine("Exiting debugger script frame");
            --DebuggerBase.this.debuggerScriptDepth;
        }

        public void onLineChange(Context cx, int lineNumber) {
        }

        public void onExceptionThrown(Context cx, Throwable ex) {
        }

        public void onDebuggerStatement(Context cx) {
        }
    }
}

