/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap<V>
implements Map<String, V> {
    private Map<String, V> wrapped;
    private Map<String, String> keymap;

    public CaseInsensitiveMap() {
        this.wrapped = new HashMap<String, V>();
        this.keymap = new HashMap<String, String>();
    }

    public CaseInsensitiveMap(Map<String, V> map) {
        assert (map != null);
        this.wrapped = map;
        this.keymap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            this.keymap.put(this.processKey(key), key);
        }
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keymap.containsKey(this.processKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (key = this.keymap.get(this.processKey(key))) == null ? null : (V)this.wrapped.get(key);
    }

    @Override
    public V put(String key, V value) {
        String pkey = this.processKey(key);
        String previousKey = this.keymap.put(pkey, key);
        V previousValue = this.wrapped.put(key, value);
        if (previousValue == null && previousKey != null) {
            previousValue = this.wrapped.remove(previousKey);
        }
        return previousValue;
    }

    @Override
    public V remove(Object key) {
        String pkey = this.processKey(key);
        String previousKey = this.keymap.remove(pkey);
        return previousKey == null ? null : (V)this.wrapped.remove(previousKey);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (String string : t.keySet()) {
            String previousKey = this.keymap.put(this.processKey(string), string);
            if (previousKey == null) continue;
            this.wrapped.remove(previousKey);
        }
        this.wrapped.putAll(t);
    }

    @Override
    public void clear() {
        this.keymap.clear();
        this.wrapped.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.wrapped.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.wrapped.entrySet();
    }

    public String toString() {
        return this.wrapped.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.wrapped.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    private String processKey(Object key) {
        assert (key != null);
        return key instanceof String ? ((String)key).toLowerCase() : key.toString().toLowerCase();
    }
}

