/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.tools.launcher;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class RingoClassLoader
extends URLClassLoader {
    public RingoClassLoader() {
        this(new URL[0]);
    }

    public RingoClassLoader(URL[] urls) {
        this(urls, RingoClassLoader.class.getClassLoader());
    }

    public RingoClassLoader(File home, String[] classpath) throws MalformedURLException {
        this(new URL[0]);
        for (String item : classpath) {
            File dir;
            if (item.endsWith(File.separator + "**") || item.endsWith("/**")) {
                dir = RingoClassLoader.getAbsoluteFile(home, item.substring(0, item.length() - 2));
                this.addClasspathWildcard(dir, true);
                continue;
            }
            if (item.endsWith(File.separator + "*") || item.endsWith("/*")) {
                dir = RingoClassLoader.getAbsoluteFile(home, item.substring(0, item.length() - 1));
                this.addClasspathWildcard(dir, false);
                continue;
            }
            File file = RingoClassLoader.getAbsoluteFile(home, item);
            this.addURL(new URL("file:" + file));
        }
    }

    public RingoClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    protected void addClasspathWildcard(File dir, boolean recursive) throws MalformedURLException {
        File[] files;
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory '" + dir + "' does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("'" + dir + "' is not a directory");
        }
        for (File file : files = dir.listFiles()) {
            if (recursive && file.isDirectory()) {
                this.addClasspathWildcard(file, true);
                continue;
            }
            String name = file.getName().toLowerCase();
            if (!file.isFile() || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
            this.addURL(new URL("file:" + file));
        }
    }

    static File getAbsoluteFile(File home, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(home, path);
    }
}

