/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.tools.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.ringojs.tools.launcher.RingoClassLoader;

public class Main {
    private Class runnerClass;
    private Object runnerInstance;

    public static void main(String[] args) {
        Main main = new Main();
        main.run(args);
    }

    public Main() {
        try {
            File home = Main.getRingoHome();
            ClassLoader loader = Main.createClassLoader(home);
            this.runnerClass = loader.loadClass("org.ringojs.tools.RingoRunner");
            this.runnerInstance = this.runnerClass.newInstance();
        }
        catch (Exception x) {
            System.err.println("Uncaught exception: ");
            x.printStackTrace();
            System.exit(2);
        }
    }

    private void run(String[] args) {
        try {
            this.runnerClass.getMethod("run", args.getClass()).invoke(this.runnerInstance, new Object[]{args});
        }
        catch (Exception x) {
            System.err.println("Uncaught exception: ");
            x.printStackTrace();
            System.exit(2);
        }
    }

    public void init(String[] args) {
        try {
            this.runnerClass.getMethod("init", args.getClass()).invoke(this.runnerInstance, new Object[]{args});
        }
        catch (Exception x) {
            System.err.println("Uncaught exception: ");
            x.printStackTrace();
            System.exit(2);
        }
    }

    public void start() {
        try {
            this.runnerClass.getMethod("start", new Class[0]).invoke(this.runnerInstance, new Object[0]);
        }
        catch (Exception x) {
            System.err.println("Uncaught exception: ");
            x.printStackTrace();
            System.exit(2);
        }
    }

    public void stop() {
        try {
            this.runnerClass.getMethod("stop", new Class[0]).invoke(this.runnerInstance, new Object[0]);
        }
        catch (Exception x) {
            System.err.println("Uncaught exception: ");
            x.printStackTrace();
            System.exit(2);
        }
    }

    public void destroy() {
        try {
            this.runnerClass.getMethod("destroy", new Class[0]).invoke(this.runnerInstance, new Object[0]);
        }
        catch (Exception x) {
            System.err.println("Uncaught exception: ");
            x.printStackTrace();
            System.exit(2);
        }
    }

    public static ClassLoader createClassLoader(File home) throws MalformedURLException {
        String classpath = System.getProperty("ringo.classpath", "lib/**");
        String[] classes = classpath.split(",");
        RingoClassLoader loader = new RingoClassLoader(home, classes);
        Thread.currentThread().setContextClassLoader(loader);
        return loader;
    }

    public static File getRingoHome() throws IOException {
        String ringoHome = System.getProperty("ringo.home");
        if (ringoHome == null) {
            ringoHome = System.getenv("RINGO_HOME");
        }
        if (ringoHome == null) {
            URL launcherUrl = Main.findUrl(Main.class.getClassLoader());
            if (launcherUrl == null) {
                launcherUrl = Main.findUrl(Thread.currentThread().getContextClassLoader());
            }
            if (launcherUrl == null) {
                launcherUrl = Main.findUrl(ClassLoader.getSystemClassLoader());
            }
            String jarUrl = launcherUrl.toString();
            if (!(jarUrl = URLDecoder.decode(jarUrl, Charset.defaultCharset().name())).startsWith("jar:") || !jarUrl.contains("!")) {
                ringoHome = System.getProperty("user.dir");
                System.err.println("Warning: ringo.home system property is not set ");
                System.err.println("         and not started from launcher.jar. Using ");
                System.err.println("         current working directory as install dir.");
            } else {
                int excl = jarUrl.indexOf("!");
                launcherUrl = new URL(jarUrl = jarUrl.substring(4, excl));
                ringoHome = new File(launcherUrl.getPath()).getParent();
                if (ringoHome == null) {
                    ringoHome = ".";
                }
            }
        }
        File home = new File(ringoHome).getCanonicalFile();
        System.setProperty("ringo.home", home.getPath());
        return home;
    }

    private static URL findUrl(ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            return ((URLClassLoader)loader).findResource("org/ringojs/tools/launcher/Main.class");
        }
        return null;
    }
}

