/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.ringojs.engine.ModuleScope;
import org.ringojs.engine.ReloadableScript;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.RingoConfig;
import org.ringojs.engine.RingoWorker;
import org.ringojs.engine.ScriptError;
import org.ringojs.repository.Repository;
import org.ringojs.repository.StringResource;
import org.ringojs.tools.RingoRunner;
import org.ringojs.wrappers.ScriptableList;

public class RingoShell {
    RingoConfig config;
    RhinoEngine engine;
    RingoWorker worker;
    Scriptable scope;
    boolean silent;
    File history;
    CodeSource codeSource = null;
    static String[] jsKeywords = new String[]{"break", "case", "catch", "continue", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with"};

    public RingoShell(RhinoEngine engine) throws IOException {
        this(engine, null, false);
    }

    public RingoShell(RhinoEngine engine, File history, boolean silent) throws IOException {
        this.config = engine.getConfig();
        this.engine = engine;
        this.history = history;
        this.worker = engine.getWorker();
        this.scope = engine.getShellScope(this.worker);
        this.silent = silent;
        if (this.config.isPolicyEnabled()) {
            Repository modules = this.config.getRingoHome().getChildRepository("modules");
            this.codeSource = new CodeSource(modules.getUrl(), (CodeSigner[])null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws IOException {
        if (this.silent) {
            this.runSilently();
            return;
        }
        this.preloadShellModule();
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        reader.setExpandEvents(false);
        reader.addCompleter((Completer)new JSCompleter());
        if (this.history == null) {
            this.history = new File(System.getProperty("user.home"), ".ringo-history");
        }
        FileHistory fileHistory = new FileHistory(this.history);
        reader.setHistory((History)fileHistory);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(fileHistory));
        PrintStream out = System.out;
        int lineno = 0;
        block5: while (true) {
            Context cx = this.engine.getContextFactory().enterContext(null);
            cx.setErrorReporter((ErrorReporter)new ToolErrorReporter(false, System.err));
            String source = "";
            String prompt = this.getPrompt();
            while (true) {
                String newline;
                if ((newline = reader.readLine(prompt)) == null) {
                    out.println();
                    out.flush();
                    System.exit(0);
                    return;
                }
                source = source + newline + "\n";
                ++lineno;
                if (cx.stringIsCompilableUnit(source)) {
                    try {
                        StringResource res = new StringResource("<stdin>", source, lineno);
                        ReloadableScript script = new ReloadableScript(res, this.engine);
                        Object result = this.worker.evaluateScript(cx, script, this.scope);
                        this.printResult(result, out);
                        if (++lineno % 10 != 0) continue block5;
                        System.gc();
                        continue block5;
                    }
                    catch (Exception ex) {
                        this.printError(ex, out, this.config.isVerbose());
                        continue block5;
                    }
                }
                prompt = this.getSecondaryPrompt();
            }
            finally {
                Context.exit();
                continue;
            }
            break;
        }
    }

    protected String getPrompt() {
        return ">> ";
    }

    protected String getSecondaryPrompt() {
        return ".. ";
    }

    protected void printResult(Object result, PrintStream out) {
        try {
            this.worker.invoke("ringo/shell", "printResult", result);
        }
        catch (Exception x) {
            if (result != Context.getUndefinedValue()) {
                out.println(Context.toString((Object)result));
            }
            out.flush();
        }
    }

    protected void printError(Exception ex, PrintStream out, boolean verbose) {
        List<ScriptError> errors = this.worker.getErrors();
        try {
            this.worker.invoke("ringo/shell", "printError", new Object[]{ex, new ScriptableList(this.scope, errors), verbose});
        }
        catch (Exception x) {
            RingoRunner.reportError(ex, out, errors, verbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSilently() throws IOException {
        int lineno = 0;
        block5: while (true) {
            String line;
            Context cx = this.engine.getContextFactory().enterContext(null);
            cx.setErrorReporter((ErrorReporter)new ToolErrorReporter(false, System.err));
            String source = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while ((line = reader.readLine()) != null) {
                source = source + line + "\n";
                ++lineno;
                if (!cx.stringIsCompilableUnit(source)) continue;
                try {
                    StringResource res = new StringResource("<stdin>", source, lineno);
                    ReloadableScript script = new ReloadableScript(res, this.engine);
                    this.worker.evaluateScript(cx, script, this.scope);
                    ++lineno;
                    continue block5;
                }
                catch (Exception ex) {
                    RingoRunner.reportError(ex, System.err, this.worker.getErrors(), this.config.isVerbose());
                    continue block5;
                }
                finally {
                    Context.exit();
                    continue block5;
                }
            }
            break;
        }
        System.exit(0);
    }

    private void preloadShellModule() {
        Thread t = new Thread(){

            public void run() {
                Context cx = RingoShell.this.engine.getContextFactory().enterContext(null);
                try {
                    RingoShell.this.worker.loadModule(cx, "ringo/shell", null);
                }
                catch (Exception exception) {
                }
                finally {
                    Context.exit();
                }
            }
        };
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    private class ShutdownHook
    extends Thread {
        FileHistory fileHistory;

        public ShutdownHook(FileHistory fileHistory) {
            this.fileHistory = fileHistory;
        }

        public void run() {
            try {
                this.fileHistory.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class JSCompleter
    implements Completer {
        Pattern variables = Pattern.compile("(^|\\s|[^\\w\\.'\"])([\\w\\.]+)$");
        Pattern keywords = Pattern.compile("(^|\\s)([\\w]+)$");

        JSCompleter() {
        }

        public int complete(String s, int i, List list) {
            int start;
            block9: {
                start = i;
                try {
                    String word;
                    Matcher match = this.keywords.matcher(s);
                    if (match.find() && s.length() == i) {
                        word = match.group(2);
                        for (String str : jsKeywords) {
                            if (!str.startsWith(word)) continue;
                            list.add(str);
                        }
                    }
                    if (!(match = this.variables.matcher(s)).find() || s.length() != i) break block9;
                    word = match.group(2);
                    Scriptable obj = RingoShell.this.scope;
                    String[] parts = word.split("\\.", -1);
                    for (int k = 0; k < parts.length - 1; ++k) {
                        Object o = ScriptableObject.getProperty((Scriptable)obj, (String)parts[k]);
                        if (o == null || o == ScriptableObject.NOT_FOUND) {
                            return start;
                        }
                        obj = ScriptRuntime.toObject((Scriptable)RingoShell.this.scope, (Object)o);
                    }
                    String lastpart = parts[parts.length - 1];
                    start = i - lastpart.length();
                    while (obj != null) {
                        Object[] ids = obj.getIds();
                        this.collectIds(ids, obj, word, lastpart, list);
                        if (list.size() <= 3 && obj instanceof ScriptableObject) {
                            ids = ((ScriptableObject)obj).getAllIds();
                            this.collectIds(ids, obj, word, lastpart, list);
                        }
                        if (!word.endsWith(".") || !(obj instanceof ModuleScope)) {
                            obj = obj.getPrototype();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Collections.sort(list);
            return start;
        }

        private void collectIds(Object[] ids, Scriptable obj, String word, String lastpart, List list) {
            for (Object id : ids) {
                String str;
                if (!(id instanceof String) || !(str = (String)id).startsWith(lastpart) && !word.endsWith(".")) continue;
                if (ScriptableObject.getProperty((Scriptable)obj, (String)str) instanceof Callable) {
                    list.add(str + "(");
                    continue;
                }
                list.add(str);
            }
        }
    }
}

