/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.ringojs.engine.ModuleScope;
import org.ringojs.engine.RhinoEngine;
import org.ringojs.engine.RingoConfig;
import org.ringojs.engine.RingoWrapFactory;
import org.ringojs.engine.ScriptError;
import org.ringojs.repository.AbstractRepository;
import org.ringojs.repository.FileRepository;
import org.ringojs.repository.ZipRepository;
import org.ringojs.security.RingoSecurityManager;
import org.ringojs.security.SecureWrapFactory;
import org.ringojs.tools.RingoShell;
import org.ringojs.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingoRunner {
    RingoConfig config;
    RhinoEngine engine;
    Context cx;
    Scriptable module;
    int optlevel;
    String scriptName = null;
    String[] scriptArgs = new String[0];
    String expr = null;
    File history = null;
    String charset;
    boolean runShell = false;
    boolean debug = false;
    boolean verbose = false;
    boolean silent = false;
    boolean legacyMode = false;
    boolean productionMode = false;
    List<String> bootScripts;
    List<String> userModules = new ArrayList<String>();
    static final String[][] options = new String[][]{{"b", "bootscript", "Run additional bootstrap script", "FILE"}, {"c", "charset", "Set character encoding for scripts (default: utf-8)", "CHARSET"}, {"D", "java-property", "Set Java system property K to value V", "K=V"}, {"d", "debug", "Run with debugger GUI", ""}, {"e", "expression", "Run the given expression as script", "EXPR"}, {"h", "help", "Display this help message", ""}, {"H", "history", "Use custom history file (default: ~/.ringo-history)", "FILE"}, {"i", "interactive", "Start shell after script file has run", ""}, {"l", "legacy-mode", "Enable __parent__ and __proto__ and suppress warnings", ""}, {"m", "modules", "Add a directory to the module search path", "DIR"}, {"o", "optlevel", "Set Rhino optimization level (-1 to 9)", "OPT"}, {"p", "production", "Disable module reloading and warnings", ""}, {"P", "policy", "Set java policy file and enable security manager", "URL"}, {"s", "silent", "Disable shell prompt and echo for piped stdin/stdout", ""}, {"V", "verbose", "Print java stack traces on errors", ""}, {"v", "version", "Print version number and exit", ""}};

    public static void main(String[] args) throws IOException {
        RingoRunner runner = new RingoRunner();
        runner.run(args);
    }

    public void parseArgs(String[] args) throws Exception {
        File file;
        String ringoHome;
        int i;
        if (args != null && args.length > 0 && (i = this.parseOptions(args)) < args.length) {
            this.scriptName = args[i];
            this.scriptArgs = new String[args.length - i];
            System.arraycopy(args, i, this.scriptArgs, 0, this.scriptArgs.length);
        }
        if ((ringoHome = System.getProperty("ringo.home")) == null) {
            ringoHome = System.getenv("RINGO_HOME");
        }
        if (ringoHome == null) {
            ringoHome = ".";
        }
        AbstractRepository home = (file = new File(ringoHome)).isFile() && StringUtils.isZipOrJarFile(ringoHome) ? new ZipRepository(file) : new FileRepository(file);
        String extraPath = System.getProperty("ringo.modulepath");
        if (extraPath == null) {
            extraPath = System.getenv("RINGO_MODULE_PATH");
        }
        if (extraPath != null) {
            Collections.addAll(this.userModules, StringUtils.split(extraPath, File.pathSeparator));
        }
        String[] systemModulePath = new String[]{"modules", "packages"};
        String[] userModulePath = this.userModules.toArray(new String[this.userModules.size()]);
        this.config = new RingoConfig(home, userModulePath, systemModulePath);
        boolean hasPolicy = System.getProperty("java.security.policy") != null;
        this.config.setPolicyEnabled(hasPolicy);
        this.config.setWrapFactory(hasPolicy ? new SecureWrapFactory() : new RingoWrapFactory());
        this.config.setMainScript(this.scriptName);
        this.config.setArguments(this.scriptArgs);
        this.config.setOptLevel(this.optlevel);
        this.config.setBootstrapScripts(this.bootScripts);
        this.config.setDebug(this.debug);
        this.config.setVerbose(this.verbose);
        this.config.setParentProtoProperties(this.legacyMode);
        this.config.setStrictVars(!this.legacyMode && !this.productionMode);
        this.config.setReloading(!this.productionMode);
        if (this.charset != null) {
            this.config.setCharset(this.charset);
        }
        this.engine = new RhinoEngine(this.config, null);
    }

    public void run(String[] args) {
        block8: {
            try {
                this.parseArgs(args);
                if (this.expr != null) {
                    this.engine.evaluateExpression(this.expr);
                }
                if (this.scriptName != null) {
                    this.engine.runScript(this.config.getMainResource(), this.scriptArgs);
                }
                if (this.scriptName == null && this.expr == null || this.runShell) {
                    if (!this.silent) {
                        try {
                            Method systemConsole = System.class.getMethod("console", new Class[0]);
                            this.silent = systemConsole.invoke(null, new Object[0]) == null;
                        }
                        catch (NoSuchMethodException systemConsole) {
                            // empty catch block
                        }
                    }
                    new RingoShell(this.engine, this.history, this.silent).run();
                    break block8;
                }
                this.engine.waitForAsyncTasks();
            }
            catch (Exception x) {
                List<ScriptError> errors = this.engine == null ? null : this.engine.getMainErrors();
                RingoRunner.reportError(x, System.err, errors, this.verbose);
                System.exit(-1);
            }
        }
    }

    public void init(String[] args) {
        try {
            this.parseArgs(args);
            if (this.scriptName == null) {
                throw new RuntimeException("daemon interface requires a script argument");
            }
            this.cx = this.engine.getContextFactory().enterContext(null);
            String moduleId = this.config.getMainResource().getModuleName();
            this.module = this.engine.loadModule(this.cx, moduleId, null);
            if (this.module instanceof ModuleScope) {
                this.module = ((ModuleScope)this.module).getExports();
            }
            this.engine.invoke(this.module, "init", new Object[0]);
        }
        catch (NoSuchMethodException moduleId) {
        }
        catch (Exception x) {
            RingoRunner.reportError(x, System.err, this.engine.getMainErrors(), this.verbose);
            System.exit(-1);
        }
    }

    public void start() {
        if (this.cx != null) {
            try {
                this.engine.invoke(this.module, "start", new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception x) {
                RingoRunner.reportError(x, System.err, this.engine.getMainErrors(), this.verbose);
                System.exit(-1);
            }
        }
    }

    public void stop() {
        if (this.cx != null) {
            try {
                this.engine.invoke(this.module, "stop", new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception x) {
                RingoRunner.reportError(x, System.err, this.engine.getMainErrors(), this.verbose);
                System.exit(-1);
            }
        }
    }

    public void destroy() {
        if (this.cx != null) {
            try {
                this.engine.invoke(this.module, "destroy", new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception x) {
                RingoRunner.reportError(x, System.err, this.engine.getMainErrors(), this.verbose);
                System.exit(-1);
            }
        }
    }

    private int parseOptions(String[] args) throws IOException {
        String option;
        int i;
        for (i = 0; i < args.length && (option = args[i]).startsWith("-"); ++i) {
            String nextArg = i < args.length - 1 ? args[i + 1] : null;
            int result = option.startsWith("--") ? this.parseLongOption(option.substring(2), nextArg) : this.parseShortOption(option.substring(1), nextArg);
            if (result < 0) break;
            i += result;
        }
        return i;
    }

    private int parseShortOption(String opt, String nextArg) throws IOException {
        int length = opt.length();
        for (int i = 0; i < length; ++i) {
            String[] def = null;
            char c = opt.charAt(i);
            for (String[] d : options) {
                if (d[0].length() != 1 || d[0].charAt(0) != c) continue;
                def = d;
                break;
            }
            if (def == null) {
                RingoRunner.unknownOptionError("-" + Character.toString(c));
            }
            String optarg = null;
            int consumedNext = 0;
            if (!def[3].equals("")) {
                if (i == length - 1) {
                    if (nextArg == null) {
                        RingoRunner.missingValueError("-" + def[0]);
                    }
                    optarg = nextArg;
                    consumedNext = 1;
                } else {
                    optarg = opt.substring(i + 1);
                    if (optarg.length() == 0) {
                        RingoRunner.missingValueError("-" + def[0]);
                    }
                }
                i = length;
            }
            this.processOption((String)def[1], optarg);
            if (i < length) continue;
            return consumedNext;
        }
        return 0;
    }

    private int parseLongOption(String opt, String nextArg) throws IOException {
        String[] def = null;
        for (String[] d : options) {
            if (!opt.equals(d[1]) && (!opt.startsWith(d[1]) || opt.charAt(d[1].length()) != '=')) continue;
            def = d;
            break;
        }
        if (def == null) {
            RingoRunner.unknownOptionError("--" + opt);
        }
        String optarg = null;
        int consumedNext = 0;
        if (!def[3].equals("")) {
            if (opt.equals(def[1])) {
                if (nextArg == null) {
                    RingoRunner.missingValueError("--" + def[1]);
                }
                optarg = nextArg;
                consumedNext = 1;
            } else {
                int length = def[1].length();
                if (opt.charAt(length) != '=') {
                    RingoRunner.missingValueError("--" + def[1]);
                }
                optarg = opt.substring(length + 1);
            }
        }
        this.processOption(def[1], optarg);
        return consumedNext;
    }

    private void processOption(String option, String arg) throws IOException {
        if ("help".equals(option)) {
            RingoRunner.printUsage();
            System.exit(0);
        } else if ("interactive".equals(option)) {
            this.runShell = true;
        } else if ("debug".equals(option)) {
            this.debug = true;
        } else if ("optlevel".equals(option)) {
            try {
                this.optlevel = Integer.parseInt(arg);
            }
            catch (NumberFormatException x) {
                RingoRunner.rangeError(option);
            }
            if (this.optlevel < -1 || this.optlevel > 9) {
                RingoRunner.rangeError(option);
            }
        } else if ("history".equals(option)) {
            this.history = new File(arg);
        } else if ("modules".equals(option)) {
            Collections.addAll(this.userModules, StringUtils.split(arg, File.pathSeparator));
        } else if ("policy".equals(option)) {
            System.setProperty("java.security.policy", arg);
            System.setSecurityManager((SecurityManager)((Object)new RingoSecurityManager()));
        } else if ("java-property".equals(option)) {
            if (arg.contains("=")) {
                String[] property = arg.split("=", 2);
                System.setProperty(property[0], property[1]);
            }
        } else if ("bootscript".equals(option)) {
            if (this.bootScripts == null) {
                this.bootScripts = new ArrayList<String>();
            }
            this.bootScripts.add(arg);
        } else if ("charset".equals(option)) {
            this.charset = arg;
        } else if ("expression".equals(option)) {
            this.expr = arg;
        } else if ("silent".equals(option)) {
            this.runShell = true;
            this.silent = true;
        } else if ("production".equals(option)) {
            this.productionMode = true;
        } else if ("verbose".equals(option)) {
            this.verbose = true;
        } else if ("legacy-mode".equals(option)) {
            this.legacyMode = true;
        } else if ("version".equals(option)) {
            RingoRunner.printVersion();
            System.exit(0);
        }
    }

    private static void missingValueError(String option) {
        RingoRunner.exitWithError(option + " option requires a value.", -1);
    }

    private static void rangeError(String option) {
        RingoRunner.exitWithError(option + " value must be a number between -1 and 9.", -1);
    }

    private static void unknownOptionError(String option) {
        RingoRunner.exitWithError("Unknown option: " + option, -1);
    }

    private static void exitWithError(String message, int code) {
        System.err.println(message);
        System.err.println("Use -h or --help for a list of supported options.");
        System.exit(code);
    }

    public static void reportError(Throwable x, PrintStream output, List<ScriptError> errors, boolean debug) {
        if (x instanceof RhinoException) {
            output.println(((RhinoException)x).details());
        } else {
            output.println(x.toString());
        }
        if (errors != null && !errors.isEmpty()) {
            for (ScriptError error : errors) {
                output.println(error);
            }
        }
        if (x instanceof RhinoException) {
            output.print(((RhinoException)x).getScriptStackTrace());
        }
        if (debug) {
            if (x instanceof WrappedException) {
                x = ((WrappedException)x).getWrappedException();
            }
            output.print("Java Exception: ");
            x.printStackTrace(output);
        }
        output.println();
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("  ringo [option] ... [script] [arg] ...");
        System.out.println("Options:");
        Formatter formatter = new Formatter(System.out);
        for (String[] opt : options) {
            String format = opt[0].length() == 0 ? "   --%2$s %4$s" : "-%1$s --%2$s %4$s";
            String def = new Formatter().format(format, opt).toString();
            formatter.format("  %1$-23s %2$s%n", def, opt[2]);
        }
    }

    public static void printVersion() {
        System.out.print("RingoJS version ");
        System.out.println(RhinoEngine.VERSION.get(0) + "." + RhinoEngine.VERSION.get(1));
    }
}

