/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.ringojs.engine.RingoConfig;
import org.ringojs.util.StringUtils;

public class RingoDebugger
extends Dim
implements TreeSelectionListener {
    RingoConfig config;
    DebugGui gui;
    JTree tree;
    JList list;
    DebuggerTreeNode treeRoot;
    DefaultTreeModel treeModel;
    HashMap treeNodes = new HashMap();
    HashMap scriptNames = new HashMap();

    public RingoDebugger(RingoConfig config) {
        this.config = config;
        this.gui = new DebugGui(this, "RingoJS Debugger");
        this.gui.pack();
        this.gui.setVisible(true);
    }

    void createTreeNode(String sourceName, Dim.SourceInfo sourceInfo) {
        String[] path = StringUtils.split(sourceName, ":/\\");
        DebuggerTreeNode node = this.treeRoot;
        DebuggerTreeNode newNode = null;
        for (int i = 0; i < path.length; ++i) {
            DebuggerTreeNode n = node.get(path[i]);
            if (n == null) {
                n = new DebuggerTreeNode(path[i]);
                node.add(n);
                if (newNode == null) {
                    newNode = n;
                }
            }
            node = n;
        }
        this.treeNodes.put(sourceName, node);
        this.scriptNames.put(node, sourceName);
        if (newNode != null) {
            SwingUtilities.invokeLater(new NodeInserter(newNode));
        }
    }

    void openScript(TreePath path) {
        if (path == null) {
            return;
        }
        Object node = path.getLastPathComponent();
        if (node == null) {
            return;
        }
        String sourceName = (String)this.scriptNames.get(node);
        if (sourceName == null) {
            return;
        }
        this.gui.showFileWindow(sourceName, -1);
    }

    void openFunction(FunctionItem function) {
        if (function == null) {
            return;
        }
        Dim.FunctionSource src = function.src;
        if (src != null) {
            Dim.SourceInfo si = src.sourceInfo();
            String url = si.url();
            int lineNumber = src.firstLine();
            this.gui.showFileWindow(url, lineNumber);
        }
    }

    protected String getNormalizedUrl(DebuggableScript fnOrScript) {
        String source = fnOrScript.getSourceName();
        try {
            return this.config.getResource(source).getUrl().toString();
        }
        catch (Exception x) {
            return source;
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object script = this.scriptNames.get(node);
        if (script != null) {
            // empty if block
        }
    }

    public void setVisible(boolean visible) {
        this.gui.setVisible(visible);
    }

    public void dispose() {
        super.dispose();
        this.gui.setVisible(false);
    }

    class FunctionItem
    implements Comparable {
        Dim.FunctionSource src;
        String name;
        String line = "";

        FunctionItem(Dim.FunctionSource src, String[] lines) {
            this.src = src;
            this.name = src.name();
            if ("".equals(this.name)) {
                try {
                    this.line = lines[src.firstLine() - 1];
                    int f = this.line.indexOf("function") - 1;
                    StringBuffer b = new StringBuffer();
                    boolean assignment = false;
                    while (f-- > 0) {
                        char c = this.line.charAt(f);
                        if (c == ':' || c == '=') {
                            assignment = true;
                            continue;
                        }
                        if (assignment && Character.isJavaIdentifierPart(c) || c == '$' || c == '.') {
                            b.append(c);
                            continue;
                        }
                        if (Character.isWhitespace(c) && b.length() <= 0) continue;
                        break;
                    }
                    this.name = b.length() > 0 ? b.reverse().toString() : "<anonymous>";
                }
                catch (Exception x) {
                    this.name = "<anonymous>";
                }
            }
        }

        public int compareTo(Object o) {
            FunctionItem other = (FunctionItem)o;
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name;
        }
    }

    class DebugGui
    extends SwingGui {
        String currentSourceUrl;

        public DebugGui(Dim dim, String title) {
            super(dim, title);
            Container contentPane = this.getContentPane();
            Component main = contentPane.getComponent(1);
            contentPane.remove(main);
            RingoDebugger.this.treeRoot = new DebuggerTreeNode(title);
            RingoDebugger.this.tree = new JTree(RingoDebugger.this.treeRoot);
            RingoDebugger.this.treeModel = new DefaultTreeModel(RingoDebugger.this.treeRoot);
            RingoDebugger.this.tree.setModel(RingoDebugger.this.treeModel);
            RingoDebugger.this.tree.getSelectionModel().setSelectionMode(1);
            RingoDebugger.this.tree.addTreeSelectionListener(RingoDebugger.this);
            RingoDebugger.this.tree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    RingoDebugger.this.openScript(RingoDebugger.this.tree.getSelectionPath());
                }
            });
            RingoDebugger.this.tree.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        RingoDebugger.this.openScript(RingoDebugger.this.tree.getSelectionPath());
                    }
                }
            });
            JScrollPane treeScroller = new JScrollPane(RingoDebugger.this.tree);
            treeScroller.setPreferredSize(new Dimension(180, 300));
            RingoDebugger.this.list = new JList();
            RingoDebugger.this.list.setFont(RingoDebugger.this.list.getFont().deriveFont(0));
            RingoDebugger.this.list.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    RingoDebugger.this.openFunction((FunctionItem)RingoDebugger.this.list.getSelectedValue());
                }
            });
            RingoDebugger.this.list.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        RingoDebugger.this.openFunction((FunctionItem)RingoDebugger.this.list.getSelectedValue());
                    }
                }
            });
            JScrollPane listScroller = new JScrollPane(RingoDebugger.this.list);
            listScroller.setPreferredSize(new Dimension(180, 200));
            JSplitPane split1 = new JSplitPane(0);
            split1.setTopComponent(treeScroller);
            split1.setBottomComponent(listScroller);
            split1.setOneTouchExpandable(true);
            split1.setResizeWeight(0.66);
            JSplitPane split2 = new JSplitPane(1);
            split2.setLeftComponent(split1);
            split2.setRightComponent(main);
            split2.setOneTouchExpandable(true);
            contentPane.add((Component)split2, "Center");
        }

        public void updateSourceText(final Dim.SourceInfo sourceInfo) {
            String filename = sourceInfo.url();
            if (!RingoDebugger.this.treeNodes.containsKey(filename)) {
                RingoDebugger.this.createTreeNode(filename, sourceInfo);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebugGui.this.updateFileWindow(sourceInfo);
                }
            });
        }

        protected void showFileWindow(String sourceName, int lineNumber) {
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            if (!sourceName.equals(this.currentSourceUrl)) {
                this.updateFunctionList(sourceName);
                DebuggerTreeNode node = (DebuggerTreeNode)RingoDebugger.this.treeNodes.get(sourceName);
                if (node != null) {
                    TreePath path = new TreePath(node.getPath());
                    RingoDebugger.this.tree.setSelectionPath(path);
                    RingoDebugger.this.tree.scrollPathToVisible(path);
                }
            }
            super.showFileWindow(sourceName, lineNumber);
        }

        private void updateFunctionList(String sourceName) {
            this.currentSourceUrl = sourceName;
            Vector<FunctionItem> functions = new Vector<FunctionItem>();
            Dim.SourceInfo si = RingoDebugger.this.sourceInfo(sourceName);
            String[] lines = si.source().split("\\r\\n|\\r|\\n");
            int length = si.functionSourcesTop();
            for (int i = 0; i < length; ++i) {
                Dim.FunctionSource src = si.functionSource(i);
                if (!sourceName.equals(src.sourceInfo().url())) continue;
                functions.add(new FunctionItem(src, lines));
            }
            RingoDebugger.this.list.setListData(functions);
        }
    }

    class NodeInserter
    implements Runnable {
        MutableTreeNode node;

        NodeInserter(MutableTreeNode node) {
            this.node = node;
        }

        public void run() {
            MutableTreeNode parent = (MutableTreeNode)this.node.getParent();
            if (parent == RingoDebugger.this.treeRoot && RingoDebugger.this.treeRoot.getChildCount() == 1) {
                RingoDebugger.this.tree.makeVisible(new TreePath(new Object[]{parent, this.node}));
            }
            RingoDebugger.this.treeModel.insertNodeInto(this.node, parent, parent.getIndex(this.node));
        }
    }

    class DebuggerTreeNode
    extends DefaultMutableTreeNode {
        public DebuggerTreeNode(Object obj) {
            super(obj);
        }

        public DebuggerTreeNode get(String name) {
            Enumeration<TreeNode> children = this.children();
            while (children.hasMoreElements()) {
                DebuggerTreeNode node = (DebuggerTreeNode)children.nextElement();
                if (node == null || !name.equals(node.getUserObject())) continue;
                return node;
            }
            return null;
        }
    }
}

