/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.test;

import junit.framework.TestCase;
import org.ringojs.engine.RhinoEngine;

public class NormalizePathTest
extends TestCase {
    public void test1() {
        String path = RhinoEngine.normalizePath("../bar/../foo/baz");
        NormalizePathTest.assertEquals((String)path, (String)"../foo/baz");
    }

    public void test2() {
        String path = RhinoEngine.normalizePath("./bar/.//../foo/baz");
        NormalizePathTest.assertEquals((String)path, (String)"foo/baz");
    }

    public void test3() {
        String path = RhinoEngine.normalizePath("bar/foo/baz");
        NormalizePathTest.assertEquals((String)path, (String)"bar/foo/baz");
    }

    public void test4() {
        String path = RhinoEngine.normalizePath("/bar/foo/baz/../BAZ");
        NormalizePathTest.assertEquals((String)path, (String)"/bar/foo/BAZ");
    }

    public void test5() {
        String path = RhinoEngine.normalizePath("bar//foo/./../baz/../../");
        NormalizePathTest.assertEquals((String)path, (String)"");
    }

    public void test6() {
        String path = RhinoEngine.normalizePath("bar/../foo/./../baz/../../../");
        NormalizePathTest.assertEquals((String)path, (String)"../..");
    }
}

