/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.test;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.ringojs.wrappers.EventAdapter;

public class EventAdapterTest
extends TestCase {
    public void testClassGen() {
        final ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Runnable.class);
        classes.add(Appendable.class);
        ContextFactory cf = ContextFactory.getGlobal();
        cf.call(new ContextAction(){

            public Object run(Context cx) {
                Class<?> c1 = EventAdapter.getAdapterClass(classes.toArray(), null);
                Class<?> c2 = EventAdapter.getAdapterClass(classes.toArray(), null);
                TestCase.assertTrue((c1.getSuperclass() == Object.class ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)Runnable.class.isAssignableFrom(c1));
                TestCase.assertTrue((boolean)Appendable.class.isAssignableFrom(c1));
                TestCase.assertEquals(c1, c2);
                return null;
            }
        });
        cf.call(new ContextAction(){

            public Object run(Context cx) {
                HashMap<String, String> bindings = new HashMap<String, String>();
                bindings.put("append", "add");
                bindings.put("run", "run");
                Class<?> c1 = EventAdapter.getAdapterClass(classes.toArray(), new HashMap(bindings));
                Class<?> c2 = EventAdapter.getAdapterClass(classes.toArray(), new HashMap(bindings));
                TestCase.assertTrue((c1.getSuperclass() == Object.class ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)Runnable.class.isAssignableFrom(c1));
                TestCase.assertTrue((boolean)Appendable.class.isAssignableFrom(c1));
                TestCase.assertEquals(c1, c2);
                return null;
            }
        });
    }
}

