/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.security;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.ringojs.engine.RingoWrapFactory;
import org.ringojs.security.RingoSecurityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureWrapFactory
extends RingoWrapFactory {
    static final RingoSecurityManager secman;

    private static void checkAccess(Class clazz) {
        if (secman != null) {
            try {
                secman.checkJavaAccess();
            }
            catch (Exception x) {
                throw new WrappedException((Throwable)x);
            }
        }
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class<?> staticType) {
        return new SecureObjectWrapper(scope, javaObject, staticType);
    }

    public Scriptable wrapJavaClass(Context cx, Scriptable scope, Class javaClass) {
        return new SecureClassWrapper(scope, javaClass);
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        secman = sm instanceof RingoSecurityManager ? (RingoSecurityManager)((Object)sm) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SecureClassWrapper
    extends NativeJavaClass {
        Class clazz;

        public SecureClassWrapper(Scriptable scope, Class<?> clazz) {
            super(scope, clazz);
            this.clazz = clazz;
        }

        public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
            SecureWrapFactory.checkAccess(this.clazz);
            return super.construct(cx, scope, args);
        }

        public Object get(String name, Scriptable start) {
            SecureWrapFactory.checkAccess(this.clazz);
            return super.get(name, start);
        }

        public Class<?> getClassObject() {
            SecureWrapFactory.checkAccess(this.clazz);
            return super.getClassObject();
        }

        public void put(String name, Scriptable start, Object value) {
            SecureWrapFactory.checkAccess(this.clazz);
            super.put(name, start, value);
        }

        public void delete(String name) {
            SecureWrapFactory.checkAccess(this.clazz);
            super.delete(name);
        }
    }

    public static class SecureObjectWrapper
    extends NativeJavaObject {
        Class clazz;

        public SecureObjectWrapper(Scriptable scope, Object javaObject, Class staticType) {
            super(scope, javaObject, staticType);
            this.clazz = javaObject.getClass();
        }

        public void put(String name, Scriptable start, Object value) {
            SecureWrapFactory.checkAccess(this.clazz);
            super.put(name, start, value);
        }

        public Object get(String name, Scriptable start) {
            SecureWrapFactory.checkAccess(this.clazz);
            return super.get(name, start);
        }

        public void delete(String name) {
            SecureWrapFactory.checkAccess(this.clazz);
            super.delete(name);
        }
    }
}

