/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.mozilla.javascript.RhinoSecurityManager;
import org.ringojs.security.RingoRuntimePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingoSecurityManager
extends RhinoSecurityManager {
    public static final Permission GET_CLASSLOADER = new RuntimePermission("getClassLoader");
    public static final Permission ACCESS_DECLARED_MEMBERS = new RuntimePermission("accessDeclaredMembers");
    public static final Permission ACCESS_JAVA = new RingoRuntimePermission("accessJava");
    public static final Permission SPAWN_THREAD = new RingoRuntimePermission("spawnThread");

    public void checkAccess(ThreadGroup g) {
        this.checkPermission(SPAWN_THREAD);
        super.checkAccess(g);
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (clazz == null) {
            throw new NullPointerException("class can't be null");
        }
        if (clazz.getClassLoader() == null) {
            return;
        }
        final Class c = this.getCurrentScriptClass();
        if (c != null && clazz.getClassLoader() == c.getClassLoader()) {
            return;
        }
        Boolean allowed = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                ProtectionDomain pd = c == null ? null : c.getProtectionDomain();
                return pd != null && Policy.getPolicy().implies(pd, ACCESS_DECLARED_MEMBERS) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (allowed.booleanValue()) {
            return;
        }
        this.checkPermission(ACCESS_DECLARED_MEMBERS);
    }

    public void checkJavaAccess() {
        final Class c = this.getCurrentScriptClass();
        if (c == null) {
            return;
        }
        Boolean allowed = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                ProtectionDomain pd = c.getProtectionDomain();
                return pd == null || Policy.getPolicy().implies(pd, ACCESS_JAVA) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (!allowed.booleanValue()) {
            throw new AccessControlException("Java access denied", ACCESS_JAVA);
        }
    }
}

