/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ringojs.repository.AbstractResource;
import org.ringojs.repository.ZipRepository;

public final class ZipResource
extends AbstractResource {
    private String entryName;
    private boolean exists;
    long length;
    long lastModified;

    protected ZipResource(String childName, ZipRepository repository, ZipEntry entry) {
        this.repository = repository;
        this.entryName = childName;
        this.exists = entry != null && !entry.isDirectory();
        this.length = this.exists ? entry.getSize() : 0L;
        this.lastModified = repository.lastModified();
        int slash = this.entryName.lastIndexOf(47);
        this.name = slash < 0 ? this.entryName : this.entryName.substring(slash + 1);
        this.path = repository.getPath() + this.name;
        this.setBaseNameFromName(this.name);
    }

    public long lastModified() {
        return this.repository.lastModified();
    }

    public long getChecksum() {
        return this.repository.lastModified();
    }

    public InputStream getInputStream() throws IOException {
        ZipFile zipfile = this.getZipFile();
        ZipEntry entry = zipfile.getEntry(this.entryName);
        if (entry == null) {
            throw new IOException("Zip resource " + this + " does not exist");
        }
        return this.stripShebang(zipfile.getInputStream(entry));
    }

    private void update() {
        try {
            ZipEntry entry = this.getZipFile().getEntry(this.entryName);
            this.exists = entry != null && !entry.isDirectory();
            this.length = this.exists ? entry.getSize() : 0L;
            this.lastModified = this.repository.lastModified();
        }
        catch (IOException ex) {
            this.exists = false;
        }
    }

    public boolean exists() throws IOException {
        if (this.lastModified != this.repository.lastModified()) {
            this.update();
        }
        return this.exists;
    }

    public URL getUrl() throws MalformedURLException {
        return new URL(this.repository.getUrl() + this.name);
    }

    public long getLength() {
        if (this.lastModified != this.repository.lastModified()) {
            this.update();
        }
        return this.length;
    }

    public int hashCode() {
        return 17 + this.path.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ZipResource && this.path.equals(((ZipResource)obj).path);
    }

    public String toString() {
        return this.getPath();
    }

    private ZipFile getZipFile() throws IOException {
        if (!(this.repository instanceof ZipRepository)) {
            throw new IOException("Parent is not a ZipRepository: " + this.repository);
        }
        return ((ZipRepository)this.repository).getZipFile();
    }
}

