/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.ringojs.repository.AbstractRepository;
import org.ringojs.repository.AbstractResource;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;
import org.ringojs.repository.ZipResource;
import org.ringojs.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipRepository
extends AbstractRepository {
    private File file;
    private WeakReference<ZipFile> zipFile;
    private final String entryPath;
    private int depth;
    private long lastModified = -1L;
    private boolean exists;

    public ZipRepository(String path) throws ZipException, IOException {
        this(new File(path));
    }

    public ZipRepository(File file) throws ZipException, IOException {
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        this.file = file;
        this.parent = null;
        this.name = file.getName();
        this.path = file.getPath() + '/';
        this.depth = 0;
        this.entryPath = "";
    }

    private ZipRepository(File file, ZipRepository parent, String entryPath) throws ZipException, IOException {
        if (entryPath == null) {
            throw new NullPointerException("entryPath must not be null");
        }
        if (entryPath.equals("")) {
            throw new IllegalArgumentException("entryPath must not be empty");
        }
        this.file = file;
        this.parent = parent;
        this.entryPath = entryPath.endsWith("/") ? entryPath : entryPath + "/";
        String[] pathArray = StringUtils.split(entryPath, SEPARATOR);
        this.depth = pathArray.length;
        this.name = pathArray[this.depth - 1];
        this.path = parent.getPath() + this.name + '/';
    }

    protected synchronized ZipFile getZipFile() throws IOException {
        ZipFile zip;
        if (this.parent instanceof ZipRepository) {
            return ((ZipRepository)this.parent).getZipFile();
        }
        ZipFile zipFile = zip = this.zipFile == null ? null : (ZipFile)this.zipFile.get();
        if (zip == null || this.lastModified != this.file.lastModified()) {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            zip = new ZipFile(this.file);
            this.zipFile = new WeakReference<ZipFile>(zip);
            this.lastModified = this.file.lastModified();
        }
        return zip;
    }

    @Override
    protected Resource lookupResource(String name) throws IOException {
        AbstractResource res = (AbstractResource)this.resources.get(name);
        if (res == null) {
            String childName = this.entryPath + name;
            ZipFile zip = this.getZipFile();
            ZipEntry entry = zip.getEntry(childName + "/");
            if (entry == null) {
                entry = zip.getEntry(childName);
            }
            res = new ZipResource(childName, this, entry);
            this.resources.put(name, res);
        }
        return res;
    }

    @Override
    public boolean exists() throws IOException {
        if (this.lastModified != this.file.lastModified()) {
            try {
                ZipFile zip = this.getZipFile();
                this.exists = this.entryPath.length() == 0 ? zip != null : zip.getEntry(this.entryPath) != null;
            }
            catch (IOException ex) {
                this.exists = false;
            }
        }
        return this.exists;
    }

    @Override
    protected AbstractRepository createChildRepository(String name) throws IOException {
        return new ZipRepository(this.file, this, this.entryPath + name);
    }

    @Override
    protected void getResources(List<Resource> list, boolean recursive) throws IOException {
        Map<String, ZipEntry> entries = this.getChildEntries();
        for (Map.Entry<String, ZipEntry> entry : entries.entrySet()) {
            String entryName = entry.getKey();
            if (!entry.getValue().isDirectory()) {
                AbstractResource res = (AbstractResource)this.resources.get(entryName);
                if (res == null) {
                    ZipEntry zipEntry = entry.getValue();
                    res = new ZipResource(zipEntry.getName(), this, zipEntry);
                    this.resources.put(entryName, res);
                }
                list.add(res);
                continue;
            }
            if (!recursive) continue;
            this.lookupRepository(entryName).getResources(list, true);
        }
    }

    @Override
    public Repository[] getRepositories() throws IOException {
        ArrayList<AbstractRepository> list = new ArrayList<AbstractRepository>();
        Map<String, ZipEntry> entries = this.getChildEntries();
        for (Map.Entry<String, ZipEntry> entry : entries.entrySet()) {
            if (!entry.getValue().isDirectory()) continue;
            list.add(this.lookupRepository(entry.getKey()));
        }
        return list.toArray(new Repository[list.size()]);
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        if (this.parent instanceof ZipRepository) {
            return new URL(this.parent.getUrl() + this.name + "/");
        }
        String baseUrl = "jar:file:" + this.file + "!/";
        return this.entryPath.length() == 0 ? new URL(baseUrl) : new URL(baseUrl + this.entryPath);
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public long getChecksum() {
        return this.file.lastModified();
    }

    public int hashCode() {
        return 17 + 37 * this.file.hashCode() + 37 * this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZipRepository)) {
            return false;
        }
        ZipRepository rep = (ZipRepository)obj;
        return this.file.equals(rep.file) && this.path.equals(rep.path);
    }

    @Override
    public String toString() {
        return "ZipRepository[" + this.path + "]";
    }

    private Map<String, ZipEntry> getChildEntries() throws IOException {
        ZipFile zipfile = this.getZipFile();
        TreeMap<String, ZipEntry> map = new TreeMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> en = zipfile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String entryName = entry.getName();
            if (!entryName.regionMatches(0, this.entryPath, 0, this.entryPath.length())) continue;
            String[] entrypath = StringUtils.split(entryName, SEPARATOR);
            if (this.depth > 0 && !this.name.equals(entrypath[this.depth - 1]) || entrypath.length != this.depth + 1) continue;
            map.put(entrypath[this.depth], entry);
        }
        return map;
    }
}

