/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import org.ringojs.repository.AbstractResource;
import org.ringojs.repository.WebappRepository;

public class WebappResource
extends AbstractResource {
    ServletContext context;
    private int exists = -1;

    protected WebappResource(ServletContext context, WebappRepository repository, String name) {
        this.context = context;
        this.repository = repository;
        this.name = name;
        this.path = repository.path + name;
        this.setBaseNameFromName(name);
    }

    public long lastModified() {
        try {
            String realPath = this.context.getRealPath(this.path);
            return realPath == null ? 0L : new File(realPath).lastModified();
        }
        catch (Exception x) {
            return 0L;
        }
    }

    public boolean exists() throws IOException {
        if (this.exists < 0) {
            try {
                URL url = this.context.getResource(this.path);
                if (url != null && url.getProtocol().equals("file")) {
                    String enc = Charset.defaultCharset().name();
                    String path = URLDecoder.decode(url.getPath(), enc);
                    this.exists = new File(path).isFile() ? 1 : 0;
                } else {
                    this.exists = url != null ? 1 : 0;
                }
            }
            catch (MalformedURLException mux) {
                this.exists = 0;
            }
        }
        return this.exists == 1;
    }

    public long getLength() {
        return 0L;
    }

    public InputStream getInputStream() throws IOException {
        return this.stripShebang(this.context.getResourceAsStream(this.path));
    }

    public URL getUrl() throws MalformedURLException {
        return this.context.getResource(this.path);
    }

    public String toString() {
        return "WebappResource[" + this.path + "]";
    }

    public int hashCode() {
        return 37 + this.path.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof WebappResource && this.path.equals(((WebappResource)obj).path);
    }
}

