/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.ringojs.repository.AbstractRepository;
import org.ringojs.repository.AbstractResource;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;
import org.ringojs.repository.WebappResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappRepository
extends AbstractRepository {
    ServletContext context;
    private int exists = -1;

    public WebappRepository(ServletContext context, String path) {
        this.context = context;
        this.parent = null;
        if (path == null) {
            path = "/";
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path;
        this.name = path;
    }

    protected WebappRepository(ServletContext context, WebappRepository parent, String name) {
        this.context = context;
        this.parent = parent;
        this.name = name;
        this.path = parent.path + name + "/";
    }

    @Override
    public long getChecksum() {
        return this.lastModified();
    }

    @Override
    public long lastModified() {
        try {
            String realPath = this.context.getRealPath(this.path);
            return realPath == null ? 0L : new File(realPath).lastModified();
        }
        catch (Exception x) {
            return 0L;
        }
    }

    @Override
    public boolean exists() throws IOException {
        if (this.exists < 0) {
            if ("/".equals(this.path)) {
                this.exists = 1;
            } else {
                try {
                    URL url = this.context.getResource(this.path);
                    if (url != null && url.getProtocol().equals("file")) {
                        String enc = Charset.defaultCharset().name();
                        String path = URLDecoder.decode(url.getPath(), enc);
                        this.exists = new File(path).isDirectory() ? 1 : 0;
                    } else {
                        this.exists = url != null ? 1 : 0;
                    }
                }
                catch (MalformedURLException mux) {
                    this.exists = 0;
                }
            }
        }
        return this.exists == 1;
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        return this.context.getResource(this.path);
    }

    @Override
    protected Resource lookupResource(String name) {
        AbstractResource res = (AbstractResource)this.resources.get(name);
        if (res == null) {
            res = new WebappResource(this.context, this, name);
            this.resources.put(name, res);
        }
        return res;
    }

    @Override
    protected AbstractRepository createChildRepository(String name) {
        return new WebappRepository(this.context, this, name);
    }

    @Override
    protected void getResources(List<Resource> list, boolean recursive) throws IOException {
        Set paths = this.context.getResourcePaths(this.path);
        if (paths != null) {
            for (Object obj : paths) {
                String name;
                int n;
                String path = (String)obj;
                if (!path.endsWith("/")) {
                    n = path.lastIndexOf(47, path.length() - 1);
                    name = path.substring(n + 1);
                    list.add(this.lookupResource(name));
                    continue;
                }
                if (!recursive) continue;
                n = path.lastIndexOf(47, path.length() - 2);
                name = path.substring(n + 1, path.length() - 1);
                AbstractRepository repo = this.lookupRepository(name);
                repo.getResources(list, true);
            }
        }
    }

    @Override
    public Repository[] getRepositories() throws IOException {
        Set paths = this.context.getResourcePaths(this.path);
        ArrayList<AbstractRepository> list = new ArrayList<AbstractRepository>();
        if (paths != null) {
            for (Object obj : paths) {
                String path = (String)obj;
                if (!path.endsWith("/")) continue;
                int n = path.lastIndexOf(47, path.length() - 2);
                String name = path.substring(n + 1, path.length() - 1);
                list.add(this.lookupRepository(name));
            }
        }
        return list.toArray(new Repository[list.size()]);
    }

    @Override
    public String toString() {
        return "WebappRepository[" + this.path + "]";
    }

    public int hashCode() {
        return 5 + this.path.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof WebappRepository && this.path.equals(((WebappRepository)obj).path);
    }
}

