/*
 * Decompiled with CFR 0.152.
 */
package org.ringojs.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.ringojs.repository.Repository;
import org.ringojs.repository.Resource;

public class StringResource
implements Resource {
    private String name;
    private int lineNumber;
    private String content;
    private long lastModified;

    public StringResource(String name, String content) {
        this(name, content, 1);
    }

    public StringResource(String name, String content, int lineNumber) {
        this.name = name;
        this.content = content;
        this.lineNumber = lineNumber;
        this.lastModified = System.currentTimeMillis();
    }

    public String getBaseName() {
        return this.name;
    }

    public long getLength() {
        return this.content.length();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content.getBytes());
    }

    public Reader getReader(String encoding) throws IOException {
        return this.getReader();
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.content);
    }

    public String getContent(String encoding) throws IOException {
        return this.getContent();
    }

    public String getContent() throws IOException {
        return this.content;
    }

    public String getRelativePath() {
        return this.name;
    }

    public boolean getStripShebang() {
        return false;
    }

    public void setStripShebang(boolean stripShebang) {
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long getChecksum() throws IOException {
        return this.lastModified() + (long)this.content.hashCode();
    }

    public boolean exists() throws IOException {
        return true;
    }

    public String getPath() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() throws UnsupportedOperationException, MalformedURLException {
        throw new UnsupportedOperationException();
    }

    public Repository getParentRepository() {
        return null;
    }

    public Repository getRootRepository() {
        return null;
    }

    public String getModuleName() {
        return this.name;
    }

    public void setAbsolute(boolean absolute) {
    }

    public boolean isAbsolute() {
        return false;
    }
}

